/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.antlr;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.TokenStream;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.jface.text.Position;
import org.eclipse.wst.xquery.compiler.problem.SyntaxProblem;
import org.eclipse.wst.xquery.core.IXQDTLanguageConstants;
import org.eclipse.wst.xquery.internal.core.parser.antlr.NewLazyTokenStream;
import org.eclipse.wst.xquery.internal.core.parser.antlr.StringLexer;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XMLLexer;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQDTLexer;
import org.eclipse.wst.xquery.internal.core.parser.antlr.XQueryLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDTParser
extends Parser
implements IXQDTLanguageConstants {
    private final NewLazyTokenStream fStream;
    private ANTLRStringStream fSource;
    private ArrayList<XQDTLexer> fLexerStack;
    private IProblemReporter fReporter;
    private String fFileName;
    protected int fLanguage;
    private List<Position> fKeywords = new ArrayList<Position>(50);

    public XQDTParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }

    public XQDTParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        this.fLexerStack = new ArrayList();
        this.fStream = (NewLazyTokenStream)input;
    }

    public void setProblemReporter(IProblemReporter reporter) {
        this.fReporter = reporter;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public void setCharSource(ANTLRStringStream source) {
        this.fSource = source;
    }

    public void setLanguageLevel(int language) {
        this.fLanguage = language;
    }

    public int getLanguageLevel() {
        return this.fLanguage;
    }

    public void pushXMLLexer() {
        XMLLexer xmlLexer = new XMLLexer((CharStream)this.fSource);
        xmlLexer.setReporter(this.fReporter);
        xmlLexer.setFileName(this.fFileName);
        xmlLexer.setIsWsExplicit(true);
        this.pushLexer(xmlLexer);
    }

    public void pushXQueryLexer() {
        XQueryLexer xqueryLexer = new XQueryLexer((CharStream)this.fSource);
        xqueryLexer.setReporter(this.fReporter);
        xqueryLexer.setFileName(this.fFileName);
        this.pushLexer(xqueryLexer);
    }

    public void pushStringLexer(boolean isAposStr) {
        StringLexer stringLexer = new StringLexer((CharStream)this.fSource, isAposStr);
        stringLexer.setReporter(this.fReporter);
        stringLexer.setFileName(this.fFileName);
        this.pushLexer(stringLexer);
    }

    public void pushLexer(XQDTLexer lexer) {
        XQDTLexer oldLexer = (XQDTLexer)this.fStream.getTokenSource();
        oldLexer.addToStack(this.fLexerStack);
        this.fStream.setTokenSource(lexer);
        oldLexer.postErrors();
    }

    public void popLexer() {
        XQDTLexer oldLexer = (XQDTLexer)this.fStream.getTokenSource();
        XQDTLexer newLexer = this.fLexerStack.remove(this.fLexerStack.size() - 1);
        this.fStream.setTokenSource(newLexer);
        oldLexer.postErrors();
    }

    public void setWsExplicit(boolean isExplicit) {
        this.fStream.setWsExplicit(isExplicit);
    }

    public void reportError(RecognitionException e) {
        if (this.fReporter != null && this.input.size() != 0) {
            SyntaxProblem problem = null;
            CommonToken t = (CommonToken)this.input.get(e.index);
            if (t.getType() != -1) {
                String errorMessage = this.getErrorMessage(e, this.getTokenNames());
                problem = new SyntaxProblem(this.fFileName, errorMessage, t.getStartIndex(), t.getStopIndex() + 1, t.getLine() - 1);
            } else {
                CommonToken last = (CommonToken)this.input.get(this.input.size() - 1);
                String errorMessage = this.getErrorMessage(e, this.getTokenNames());
                problem = new SyntaxProblem(this.fFileName, errorMessage, last.getStopIndex() + 1, last.getStopIndex() + 1, last.getLine() - 1);
            }
            if (problem != null) {
                this.fReporter.reportProblem((IProblem)problem);
            }
        }
        super.reportError(e);
    }

    protected void ak(List list) {
        if (list == null) {
            return;
        }
        for (Object object : list) {
            CommonToken token = (CommonToken)object;
            this.fKeywords.add(new Position(token.getStartIndex(), token.getStopIndex() - token.getStartIndex() + 1));
        }
    }

    public List<Position> getKeywords() {
        return this.fKeywords;
    }

    protected void ak(CommonToken token) {
        this.fKeywords.add(new Position(token.getStartIndex(), token.getStopIndex() - token.getStartIndex() + 1));
    }

    public void setLanguageVersion(String languageVersion) {
        if ("1.0-ml".equals(languageVersion)) {
            this.fLanguage = 16;
        }
    }

    protected boolean lc(int languageMask) {
        return (this.fLanguage & languageMask) == languageMask;
    }

    public void reset() {
        super.reset();
        if (this.fLexerStack != null) {
            this.fLexerStack.clear();
            this.fKeywords.clear();
            this.fStream.setWsExplicit(false);
        }
    }

    public void postErrors() {
        XQDTLexer lexer = (XQDTLexer)this.fStream.getTokenSource();
        lexer.postErrors();
    }
}

