/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Preconditions;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VersionExclusionStrategy
implements ExclusionStrategy {
    private final double version;

    public VersionExclusionStrategy(double version) {
        Preconditions.checkArgument(version >= 0.0);
        this.version = version;
    }

    @Override
    public boolean shouldSkipField(Field f) {
        return !this.isValidVersion(f.getAnnotations());
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        return !this.isValidVersion(clazz.getAnnotations());
    }

    private boolean isValidVersion(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (!this.isValidSince(annotation) || !this.isValidUntil(annotation)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isValidSince(Annotation annotation) {
        double annotationVersion;
        return !(annotation instanceof Since) || !((annotationVersion = ((Since)annotation).value()) > this.version);
    }

    private boolean isValidUntil(Annotation annotation) {
        double annotationVersion;
        return !(annotation instanceof Until) || !((annotationVersion = ((Until)annotation).value()) <= this.version);
    }
}

