/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryMainModule;
import org.eclipse.wst.xquery.debug.dbgp.DbgpResponse;
import org.eclipse.wst.xquery.debug.dbgp.InitPacket;
import org.eclipse.wst.xquery.debug.dbgp.XmlElement;
import org.eclipse.wst.xquery.debug.dbgp.client.DbgpProxyClientReceiver;
import org.eclipse.wst.xquery.debug.dbgp.client.DbgpProxyClientResponder;
import org.eclipse.wst.xquery.debug.dbgp.client.IDbgpCommandListener;
import org.eclipse.wst.xquery.debug.dbgp.client.IDbgpTranslator;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.IDebugEventListener;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.ZorbaDebuggerEngine;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractCommandMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ClearMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.EvaluatedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SetMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SuspendedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.TerminateMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.TerminatedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.VariablesMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.VariablesPayload;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.Breakpoint;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.QueryLocation;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.Variable;

public class ZorbaDbgpTranslator
extends DbgpWorkingThread
implements IDbgpTranslator,
IDebugEventListener,
IDbgpTerminationListener {
    private static final Map<String, String> SUPPORTED_FEATURES = new HashMap<String, String>();
    private IScriptProject fProject;
    private String fIdeKey;
    private URI fFileUri;
    private DbgpProxyClientReceiver fReceiver;
    private DbgpProxyClientResponder fResponder;
    private ZorbaDebuggerEngine fEngine;
    private boolean fStarted = false;
    private boolean fTerminated = false;
    private DbgpRequest fLastContinuationCommand;
    private DbgpRequest fLastStackGetCommand;
    private SuspendedMessage fLastSuspendedEvent;

    static {
        SUPPORTED_FEATURES.put("language_supports_threads", "0");
        SUPPORTED_FEATURES.put("language_name", "XQuery");
        SUPPORTED_FEATURES.put("language_version", "1.1");
        SUPPORTED_FEATURES.put("encoding", "UTF-8");
        SUPPORTED_FEATURES.put("protocol_version", "1");
        SUPPORTED_FEATURES.put("supports_async", "1");
        SUPPORTED_FEATURES.put("breakpoint_types", "line");
        SUPPORTED_FEATURES.put("multiple_sessions", "0");
        SUPPORTED_FEATURES.put("max_children", "32");
        SUPPORTED_FEATURES.put("max_data", "1024");
        SUPPORTED_FEATURES.put("max_depth", "1");
    }

    public ZorbaDbgpTranslator(IScriptProject project, InetAddress ideAdress, int port, String ideKey, URI fileUri, String debuggerPorts) throws IOException {
        super(ZorbaDbgpTranslator.class.getSimpleName());
        this.fProject = project;
        Socket client = new Socket(ideAdress, port);
        this.fReceiver = new DbgpProxyClientReceiver((DbgpWorkingThread)this, (InputStream)new DataInputStream(client.getInputStream()));
        this.fResponder = new DbgpProxyClientResponder((DbgpWorkingThread)this, (OutputStream)new DataOutputStream(client.getOutputStream()));
        String[] ports = debuggerPorts.split(":");
        this.fEngine = new ZorbaDebuggerEngine(Integer.parseInt(ports[0]), Integer.parseInt(ports[1]));
        this.fEngine.addTerminationListener(this);
        this.fEngine.addDebugEventListener(this);
        this.fReceiver.addCommandListener((IDbgpCommandListener)this);
        this.fEngine.connect();
        this.fIdeKey = ideKey;
        this.fFileUri = fileUri;
    }

    public void commandReceived() {
        this.processNext();
    }

    protected synchronized void workingCycle() throws Exception {
        try {
            this.fReceiver.start();
            this.fResponder.start();
            InitPacket ip = new InitPacket(this.fIdeKey, Thread.currentThread().getId(), this.fFileUri);
            this.fResponder.send((XmlElement)ip);
            try {
                while (true) {
                    DbgpResponse response;
                    DbgpRequest request;
                    if (!this.fReceiver.hasAvailableCommand()) {
                        this.wait();
                        if (this.fTerminated) break;
                    }
                    if ((request = this.fReceiver.retrieveCommand()) == null || (response = this.processCommand(request)) == null) continue;
                    this.fResponder.send((XmlElement)response);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Exiting the command translator");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fireObjectTerminated(e);
            return;
        }
        this.fireObjectTerminated(null);
    }

    private synchronized void processNext() {
        this.notify();
    }

    private synchronized DbgpResponse processCommand(final DbgpRequest request) {
        DbgpResponse response = null;
        String command = request.getCommand();
        if (command.equals("feature_set")) {
            response = new DbgpResponse(request);
            response.addAttribute("feature", request.getOption("-n"));
            response.addAttribute("success", "1");
        } else if (command.equals("feature_get")) {
            response = new DbgpResponse(request);
            String name = request.getOption("-n");
            String value = SUPPORTED_FEATURES.get(name);
            response.addAttribute("feature", name);
            response.addAttribute("supported", value != null ? "1" : "0");
            if (value != null) {
                response.setData(SUPPORTED_FEATURES.get(name));
            }
        } else if (command.equals("stdout")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "1");
        } else if (command.equals("stderr")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "1");
        } else if (command.equals("run")) {
            this.fLastContinuationCommand = request;
            if (!this.fStarted) {
                this.fStarted = true;
                this.fEngine.run();
            } else {
                this.fEngine.resume();
            }
        } else if (command.equals("step_into") || command.equals("step_out") || command.equals("step_over")) {
            this.fLastContinuationCommand = request;
            this.fEngine.resume();
        } else if (command.equals("stop")) {
            this.fLastContinuationCommand = request;
            this.fEngine.terminate();
            response = new DbgpResponse(request);
            response.addAttribute("status", "stopped");
            response.addAttribute("reason", "ok");
            this.fireObjectTerminated(null);
        } else if (command.equals("break")) {
            this.fLastContinuationCommand = request;
            this.fEngine.suspend();
        } else if (command.equals("stack_get")) {
            this.fLastStackGetCommand = request;
            this.processStackRequestAndSuspendedMesage();
        } else if (command.equals("context_names")) {
            response = new DbgpResponse(request);
            response.setData("<context name='Local' id='0'/><context name='Global' id='1'/>");
        } else if (command.equals("context_get")) {
            response = new DbgpResponse(request);
            String contextID = request.getOption("-c");
            response.addAttribute("context", contextID);
            VariablesMessage varsCmd = new VariablesMessage();
            varsCmd.setFlags(4);
            ReplyMessage reply = (ReplyMessage)this.fEngine.sendCommand(varsCmd);
            VariablesPayload payload = varsCmd.getVariables(reply);
            List<Variable> variables = payload.getGlobalVariables();
            if (contextID == null) {
                variables.addAll(payload.getLocalVariables());
            }
            if (contextID.equals("0")) {
                variables = payload.getLocalVariables();
            }
            StringBuffer data = new StringBuffer();
            for (Variable variable : variables) {
                data.append("<property ");
                String name = variable.getName();
                name = name.equals("$$dot") ? ". (context item)" : "$" + name;
                String type = variable.getType();
                if (type.length() == 0) {
                    type = "xs:integer*";
                }
                data.append("name='" + name + "' ");
                data.append("fullname='" + name + "' ");
                data.append("type='" + type + "' ");
                data.append("constant='0' ");
                if (type.endsWith("*")) {
                    data.append("children='1' ");
                } else {
                    data.append("children='0' ");
                }
                if (variable.getValue() == null) {
                    data.append("size='0'>");
                } else {
                    data.append("size='" + variable.getValue().length() + "'>");
                    data.append(variable.getValue());
                }
                data.append("</property>");
            }
            response.setData(data.toString());
        } else if (command.equals("property_set")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "0");
        } else if (command.equals("breakpoint_set")) {
            SetMessage set = new SetMessage();
            int line = Integer.parseInt(request.getOption("-n"));
            String filename = request.getOption("-f");
            String namespace = null;
            try {
                URI fileUri = new URI(filename);
                namespace = new Path(fileUri.getPath()).toOSString();
            }
            catch (URISyntaxException uRISyntaxException) {}
            if (namespace == null) {
                response = new DbgpResponse(request);
                response.addAttribute("state", "0");
            } else {
                QueryLocation ql = new QueryLocation(namespace, line, 0, line, 0);
                int id = set.hashCode();
                String state = request.getOption("-s");
                set.addBreakpoint(new Breakpoint(id, ql));
                this.fEngine.sendCommand(set);
                response = new DbgpResponse(request);
                response.addAttribute("state", state);
                response.addAttribute("id", "" + id);
            }
        } else if (command.equals("breakpoint_get")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "0");
        } else if (command.equals("breakpoint_remove")) {
            ClearMessage clear = new ClearMessage();
            clear.addBreakpointId(Integer.parseInt(request.getOption("-d")));
            this.fEngine.sendCommand(clear);
            response = new DbgpResponse(request);
        } else if (command.equals("breakpoint_rupdate")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "0");
        } else if (command.equals("source")) {
            response = new DbgpResponse(request);
            response.addAttribute("success", "0");
        } else if (command.equals("eval")) {
            int tID = Integer.parseInt(request.getOption("-i"));
            this.fEngine.addEvalEventListener(new IDebugEventListener(){

                public void handleDebugEvent(AbstractCommandMessage event) {
                    if (event instanceof EvaluatedMessage) {
                        EvaluatedMessage evald = (EvaluatedMessage)event;
                        ZorbaDbgpTranslator.this.fEngine.removeDebugEventListener(this);
                        DbgpResponse response = new DbgpResponse(request);
                        response.addAttribute("success", "1");
                        String encodedValue = Base64Helper.encodeString((String)evald.getResults());
                        response.setData("<property type='string' encoding='base64'>" + encodedValue + "</property>");
                        ZorbaDbgpTranslator.this.fResponder.send((XmlElement)response);
                    }
                }
            }, 0);
            this.fEngine.evaluate(request.getData(), tID);
        }
        return response;
    }

    private synchronized void processStackRequestAndSuspendedMesage() {
        if (this.fLastStackGetCommand == null || this.fLastSuspendedEvent == null) {
            return;
        }
        QueryLocation ql = this.fLastSuspendedEvent.getLocation();
        String filename = ql.getFileName();
        if (filename.startsWith("file:/")) {
            try {
                URI fileUri = new URI(filename);
                filename = new Path(fileUri.getPath()).toOSString();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        filename = new File(filename).toURI().toString();
        int lineno = ql.getLineBegin();
        String cmdbegin = String.valueOf(ql.getLineBegin()) + ":" + (ql.getColumnBegin() - 1);
        String cmdend = String.valueOf(ql.getLineEnd()) + ":" + (ql.getColumnEnd() - 2);
        DbgpResponse response = new DbgpResponse(this.fLastStackGetCommand);
        response.setData("<stack level='0' type='file' filename='" + filename + "' " + "lineno='" + lineno + "' " + "cmdbegin='" + cmdbegin + "' " + "cmdend='" + cmdend + "' " + "/>");
        this.fResponder.send((XmlElement)response);
        this.fLastSuspendedEvent = null;
        this.fLastStackGetCommand = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getModuleNamespace(String filename) {
        try {
            URI fileUri = new URI(filename);
            String fileStr = fileUri.getPath();
            Path filePath = new Path(fileStr);
            IPath projectPath = this.fProject.getResource().getLocation();
            if (!projectPath.isPrefixOf((IPath)filePath)) return null;
            IPath relativePath = filePath.removeFirstSegments(projectPath.segmentCount());
            relativePath = relativePath.setDevice(null);
            try {
                IModelElement element = this.fProject.findElement(relativePath);
                if (!(element instanceof ISourceModule)) return null;
                ModuleDeclaration decl = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)element));
                if (decl instanceof XQueryMainModule) {
                    return "main module";
                }
                if (!(decl instanceof XQueryLibraryModule)) return null;
                XQueryLibraryModule library = (XQueryLibraryModule)decl;
                return library.getNamespaceUri().getValue();
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    public void handleDebugEvent(AbstractCommandMessage event) {
        System.out.println(event.toString());
        DbgpResponse response = null;
        if (event instanceof TerminatedMessage) {
            response = new DbgpResponse(this.fLastContinuationCommand);
            response.addAttribute("status", "stopping");
            response.addAttribute("reason", "ok");
            this.fResponder.send((XmlElement)response);
            try {
                this.fEngine.sendCommand(new TerminateMessage());
            }
            catch (Exception exception) {}
        } else if (event instanceof SuspendedMessage) {
            SuspendedMessage sm;
            this.fLastSuspendedEvent = sm = (SuspendedMessage)event;
            this.processStackRequestAndSuspendedMesage();
            response = new DbgpResponse(this.fLastContinuationCommand);
            if (sm.getCause() == 1) {
                response.addAttribute("success", "1");
            } else {
                response.addAttribute("status", "break");
                response.addAttribute("reason", "ok");
            }
            this.fResponder.send((XmlElement)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectTerminated(Object object, Exception e) {
        try {
            System.out.println("waiting for engine");
            this.fEngine.waitTerminated();
            System.out.println("waited for engine");
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.fTerminated = true;
        ZorbaDbgpTranslator zorbaDbgpTranslator = this;
        synchronized (zorbaDbgpTranslator) {
            this.notify();
        }
    }
}

