/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractCommandMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.SequenceItemResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatedMessage
extends AbstractCommandMessage {
    @SerializedName(value="id")
    private int fExprId;
    @SerializedName(value="expr")
    private String fExpr;
    @SerializedName(value="results")
    private List<SequenceItemResult> fResultSequence;
    @SerializedName(value="type")
    private String fType;
    @SerializedName(value="error")
    private String fError;

    public EvaluatedMessage() {
        super(248, 63493);
    }

    public EvaluatedMessage(int exprID, String expr, List<SequenceItemResult> sequence, String type, String error) {
        super(248, 63493);
        this.fExprId = exprID;
        this.fExpr = expr;
        this.fResultSequence = sequence;
        this.fType = type;
        this.fError = error;
    }

    public String getError() {
        return this.fError;
    }

    public void setErrorCode(String error) {
        this.fError = error;
    }

    public int getExprId() {
        return this.fExprId;
    }

    public void setExprId(int exprId) {
        this.fExprId = exprId;
    }

    public String getExpr() {
        return this.fExpr;
    }

    public void setExpr(String expr) {
        this.fExpr = expr;
    }

    public List<SequenceItemResult> getResultSequence() {
        return this.fResultSequence;
    }

    public void setResultSequence(List<SequenceItemResult> sequence) {
        this.fResultSequence = sequence;
    }

    public String getResults() {
        if (this.fResultSequence == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SequenceItemResult item : this.fResultSequence) {
            sb.append(String.valueOf(item.getValue()) + " ");
        }
        String result = sb.toString().trim();
        return "(" + result + ")";
    }

    public String getType() {
        return this.fType;
    }

    public void setType(String type) {
        this.fType = type;
    }

    @Override
    public byte[] serializeData() {
        Gson g = new Gson();
        return g.toJson((Object)this).getBytes();
    }
}

