/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ConnectionProvider;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;

public class SimpleConnection
implements ServerConnection {
    private final ByteChannel channel;
    private final ConnectionProvider provider;
    private long timeoutTime = 0L;

    public SimpleConnection(ByteChannel channel, ConnectionProvider provider) {
        this.channel = channel;
        this.provider = provider;
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public ConnectionProvider provider() {
        return this.provider;
    }

    public long getTimeoutMillis() {
        long millis = this.timeoutTime - System.currentTimeMillis();
        return millis < 0L ? 0L : millis;
    }

    @Deprecated
    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutTime = System.currentTimeMillis() + timeoutMillis;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void setTimeoutTime(long timeMillis) {
        this.timeoutTime = timeMillis;
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {}
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "SimpleConnection [provider: " + this.provider.toString() + "]";
    }
}

