/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl.handlers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.HttpChannel;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.AbstractRequestController;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.GoodQueryResponseHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.NotFoundCodeHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ResponseHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ServerExceptionHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ServiceUnavailableHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.UnauthorizedHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.UnrecognizedCodeHandler;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;

public class EvalRequestController
extends AbstractRequestController {
    private static final Map<Integer, ResponseHandler> handlers = new HashMap<Integer, ResponseHandler>(8);
    private final String body;
    private final String path;

    static {
        EvalRequestController.addDefaultHandler(handlers, new UnrecognizedCodeHandler());
        EvalRequestController.addHandler(handlers, 503, new ServiceUnavailableHandler());
        EvalRequestController.addHandler(handlers, 500, new ServerExceptionHandler());
        EvalRequestController.addHandler(handlers, 401, new UnauthorizedHandler());
        EvalRequestController.addHandler(handlers, 404, new NotFoundCodeHandler());
        EvalRequestController.addHandler(handlers, 400, new NotFoundCodeHandler());
        EvalRequestController.addHandler(handlers, 200, new GoodQueryResponseHandler());
    }

    public EvalRequestController(String path, String body) {
        super(handlers);
        this.path = path;
        this.body = body;
    }

    public ResultSequence serverDialog(ServerConnection connection, Request request, RequestOptions options, Logger logger) throws IOException, RequestException {
        SessionImpl session = (SessionImpl)request.getSession();
        HttpChannel http = this.buildChannel(connection, this.path, session, options, logger);
        this.issueRequest(http, this.body, logger);
        int code = http.getResponseCode();
        this.setConnectionTimeout(connection, http);
        return (ResultSequence)this.findHandler(code).handleResponse(http, code, request, connection, logger);
    }

    protected long interTryDelay(long delay, int currentTry) {
        if (currentTry == 0 || delay <= 0L) {
            return 0L;
        }
        return delay;
    }

    private HttpChannel buildChannel(ServerConnection connection, String path, SessionImpl session, RequestOptions options, Logger logger) {
        String method = "POST";
        HttpChannel http = new HttpChannel(connection.channel(), method, path, this.body.length(), options.getTimeoutMillis(), logger);
        http.setRequestContentType("application/x-www-form-urlencoded");
        http.setCloseOutputIfNoContentLength(true);
        this.addCommonHeaders(http, session, method, path, options);
        return http;
    }

    private void issueRequest(HttpChannel http, String encodedQuery, Logger logger) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("encoded query: " + encodedQuery);
        }
        logger.fine("writing query to HttpChannel");
        http.writeString(encodedQuery);
        int code = http.getResponseCode();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("response: " + code + " (" + http.getResponseMessage() + ")");
        }
    }
}

