/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text.codeassist;

import org.eclipse.dltk.ui.templates.ScriptTemplateCompletionProcessor;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xquery.core.codeassist.IXQDTCompletionConstants;
import org.eclipse.wst.xquery.core.text.XQDTWordDetector;

public abstract class XQDTPrefixedTemplateCompletionProcessor
extends ScriptTemplateCompletionProcessor {
    protected String fPrefixPrefix;
    protected IXQDTCompletionConstants.CompletionPrefixType fPrefixType;
    private Image fImage;

    public XQDTPrefixedTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        super(context);
    }

    protected abstract ImageDescriptor getImageDescriptor();

    protected Image getImage(Template template) {
        ImageDescriptor descriptor = this.getImageDescriptor();
        if (descriptor == null) {
            return null;
        }
        if (this.fImage == null) {
            this.fImage = this.getImageDescriptor().createImage();
        }
        return this.fImage;
    }

    protected boolean isMatchingTemplate(Template template, String prefix, TemplateContext context) {
        if (!template.getName().startsWith(prefix)) {
            return false;
        }
        return template.matches(prefix, context.getContextType().getId());
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        int i = offset;
        IDocument document = viewer.getDocument();
        char[] content = document.get().toCharArray();
        if (i > content.length) {
            return "";
        }
        XQDTWordDetector wd = new XQDTWordDetector();
        String word = this.extractWord(content, offset, wd, true);
        if (this.fPrefixType == IXQDTCompletionConstants.CompletionPrefixType.COLON) {
            String namespace;
            int prefixLen = word.length();
            this.fPrefixPrefix = namespace = this.extractWord(content, offset - (prefixLen + 1), wd, false);
        }
        return word;
    }

    private String extractWord(char[] content, int offset, XQDTWordDetector wd, boolean checkPrefixPrefix) {
        int i = offset;
        char ch = '\u0000';
        while (i > 0) {
            ch = content[i - 1];
            if (!wd.isWordPart(ch)) break;
            --i;
        }
        if (checkPrefixPrefix) {
            this.fPrefixType = ch == ':' ? IXQDTCompletionConstants.CompletionPrefixType.COLON : (ch == '$' ? IXQDTCompletionConstants.CompletionPrefixType.DOLLAR : (ch == '&' ? IXQDTCompletionConstants.CompletionPrefixType.AMPERSAND : IXQDTCompletionConstants.CompletionPrefixType.NORMAL));
        }
        return new String(content, i, offset - i);
    }
}

