/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.deploy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.xquery.set.internal.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETCoreSDKDeployCommandJob;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployDataJob;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETDeployProjectJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer {
    private DeployInfo fDeployInfo;
    private List<Job> fJobs;
    private String fLastError;

    public Deployer(DeployInfo info) {
        this.fDeployInfo = info;
        this.initJobs();
    }

    public void initJobs() {
        this.fJobs = new ArrayList<Job>(1);
        switch (this.fDeployInfo.getDeployType()) {
            case PROJECT: {
                this.fJobs.add(new SETDeployProjectJob(this.fDeployInfo, null));
                break;
            }
            case DATA: {
                this.fJobs.add(new SETDeployDataJob(this.fDeployInfo, null));
                break;
            }
            case PROJECT_AND_DATA: {
                this.fJobs.add(new SETDeployProjectJob(this.fDeployInfo, null));
                this.fJobs.add(new SETDeployDataJob(this.fDeployInfo, null));
            }
        }
    }

    public DeployInfo getDeployInfo() {
        return this.fDeployInfo;
    }

    public void setDeployInfo(DeployInfo info) {
        this.fDeployInfo = info;
        for (Job job : this.fJobs) {
            if (!(job instanceof SETCoreSDKDeployCommandJob)) continue;
            ((SETCoreSDKDeployCommandJob)job).setDeployInfo(this.fDeployInfo);
        }
    }

    public void execute() {
        final Iterator<Job> iterator = this.fJobs.iterator();
        JobChangeAdapter trigger = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getJob().getResult();
                if (result.isOK()) {
                    Deployer.this.triggerNextJob(iterator, (IJobChangeListener)this);
                } else {
                    Deployer.this.setError(result.getMessage());
                }
            }
        };
        this.triggerNextJob(iterator, (IJobChangeListener)trigger);
    }

    public void triggerNextJob(Iterator<Job> jobIterator, IJobChangeListener jobTrigger) {
        if (jobIterator.hasNext()) {
            Job currentJob = jobIterator.next();
            currentJob.addJobChangeListener(jobTrigger);
            currentJob.schedule();
        }
    }

    public void addJobChangeListener(IJobChangeListener listener) {
        for (Job job : this.fJobs) {
            job.addJobChangeListener(listener);
        }
    }

    private void setError(String error) {
        this.fLastError = error;
    }

    public String getError() {
        return this.fLastError;
    }
}

