/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching.jobs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xquery.set.internal.launching.deploy.DeployInfo;
import org.eclipse.wst.xquery.set.internal.launching.jobs.SETCoreSDKDeployCommandJob;

public class SETDeployDataJob
extends SETCoreSDKDeployCommandJob {
    private static final String BULKLOAD_PATH = "test/data/bulkload";

    public SETDeployDataJob(DeployInfo info, OutputStream output) {
        super("Deploying project data", info, output);
    }

    protected int getJobTaskSize() {
        IFolder folder = this.fProject.getFolder(BULKLOAD_PATH);
        if (!folder.exists()) {
            return 0;
        }
        final HashSet names = new HashSet();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1) {
                        IPath path = resource.getFullPath();
                        String ext = path.getFileExtension();
                        if (ext.equals("xq") || ext.equals("xml")) {
                            names.add(path.removeFileExtension().lastSegment());
                        }
                        return false;
                    }
                    return true;
                }
            }, 1, 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return names.size();
    }

    protected String getJobTaskName() {
        return "Importing data for project: " + this.fProject.getName();
    }

    protected void readCommandOutput(InputStream inputStream) throws IOException {
        OutputStream output = this.getOutputStream();
        BufferedReader ir = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = ir.readLine()) != null) {
            if (line.startsWith("Deploying file ")) {
                this.updateMonitorTaskName(line);
            } else if (line.startsWith("  done") || line.startsWith("  failed")) {
                this.updateMonitorWork(1);
            }
            if (output == null) continue;
            output.write((String.valueOf(line) + "\n").getBytes());
        }
    }

    protected SETCoreSDKDeployCommandJob.DeployType getDeployType() {
        return SETCoreSDKDeployCommandJob.DeployType.DEPLOY_DATA;
    }
}

