/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;

public class CoreSdkUtil {
    public static IPath getCoreSDKScriptPath(IProject project) throws CoreException {
        IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)DLTKCore.create((IProject)project));
        return install.getInstallLocation().getPath();
    }

    public static IPath getProjectCoreSDKInstallationPath(IProject project) throws CoreException {
        return CoreSdkUtil.getCoreSDKScriptPath(project).removeLastSegments(2);
    }

    public static IPath getKillCommandPath(IProject project) {
        if (Platform.getOS().equals("win32")) {
            try {
                return CoreSdkUtil.getProjectCoreSDKInstallationPath(project).append("bin").append("term.exe");
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return new Path("kill");
    }

    public static IPath getDefaultCoreSDKInstallationPath() throws CoreException {
        ScriptRuntime.DefaultInterpreterEntry[] entries;
        ScriptRuntime.DefaultInterpreterEntry[] defaultInterpreterEntryArray = entries = ScriptRuntime.getDefaultInterpreterIDs();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptRuntime.DefaultInterpreterEntry entry = defaultInterpreterEntryArray[n2];
            if (entry.getNature().equals("org.eclipse.wst.xquery.set.core.nature")) {
                IInterpreterInstall install = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)entry);
                if (install == null) {
                    return null;
                }
                return install.getInstallLocation().getPath().removeLastSegments(2);
            }
            ++n2;
        }
        return null;
    }
}

