/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.wst.xquery.debug.dbgp.XmlElement;

public class DbgpProxyClientResponder
extends DbgpWorkingThread
implements IDbgpTerminationListener {
    private final OutputStream fOutputStream;
    private final Queue<XmlElement> fResponseQueue = new ConcurrentLinkedQueue<XmlElement>();
    private final Object fTerminatedLock = new Object();
    private boolean fTerminated = false;
    private DbgpWorkingThread fTranslator;

    public DbgpProxyClientResponder(DbgpWorkingThread translator, OutputStream outputStream) {
        super(DbgpProxyClientResponder.class.getSimpleName());
        this.fOutputStream = outputStream;
        this.fTranslator = translator;
        this.fTranslator.addTerminationListener((IDbgpTerminationListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void workingCycle() throws Exception {
        try {
            block3: while (true) {
                if (this.hasTerminated() && this.fResponseQueue.isEmpty()) {
                    return;
                }
                do {
                    if (!this.fResponseQueue.isEmpty()) {
                        XmlElement xe = this.fResponseQueue.remove();
                        String data = xe.toXml();
                        String length = "" + data.length();
                        this.fOutputStream.write(length.getBytes());
                        this.fOutputStream.write(0);
                        this.fOutputStream.write(data.getBytes());
                        this.fOutputStream.write(0);
                        this.fOutputStream.flush();
                        System.out.println("sent: " + data);
                        continue block3;
                    }
                    Thread.sleep(150L);
                } while (!this.hasTerminated());
                break;
            }
            return;
        }
        catch (InterruptedException ie) {
            System.err.println("Responder exception: " + ie.getMessage());
            System.out.println("Responder exception: terminating responder");
            return;
        }
        catch (IOException ioe) {
            System.err.println("Responder exception: " + ioe.getMessage());
            System.out.println("Responder exception: terminating responder");
        }
    }

    private boolean hasTerminated() {
        return this.fTerminated;
    }

    public void terminate() {
        this.fTerminated = true;
    }

    public void send(XmlElement response) {
        if (!this.fTerminated) {
            this.fResponseQueue.add(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectTerminated(Object object, Exception e) {
        Object object2 = this.fTerminatedLock;
        synchronized (object2) {
            if (this.fTerminated) {
                return;
            }
            try {
                this.fOutputStream.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.fTranslator.removeTerminationListener((IDbgpTerminationListener)this);
            try {
                this.fTranslator.waitTerminated();
            }
            catch (InterruptedException interruptedException) {}
            this.fTerminated = true;
        }
        this.fireObjectTerminated(e);
    }
}

