/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.codeassist;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.wst.xquery.core.IXQDTUriResolver;
import org.eclipse.wst.xquery.core.XQDTCorePlugin;
import org.eclipse.wst.xquery.core.codeassist.IXQDTCompletionConstants;
import org.eclipse.wst.xquery.core.codeassist.XQDTKeywords;
import org.eclipse.wst.xquery.core.model.ast.XQueryLibraryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;
import org.eclipse.wst.xquery.core.model.ast.XQueryModuleImport;
import org.eclipse.wst.xquery.core.model.ast.XQueryStringLiteral;
import org.eclipse.wst.xquery.core.text.XQDTWordDetector;
import org.eclipse.wst.xquery.core.utils.LanguageUtil;
import org.eclipse.wst.xquery.core.utils.ResolverUtil;
import org.eclipse.wst.xquery.internal.core.codeassist.ImplicitImport;
import org.eclipse.wst.xquery.internal.core.codeassist.ImplicitImportsRegistry;
import org.eclipse.wst.xquery.internal.core.codeassist.XQDTAssistParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDTCompletionEngine
extends ScriptCompletionEngine
implements IXQDTCompletionConstants {
    protected XQDTAssistParser fParser;
    protected org.eclipse.dltk.core.ISourceModule fSourceModule;
    protected int fLanguageLevel;
    protected String fPrefix;
    protected IXQDTCompletionConstants.CompletionPrefixType fPrefixType = IXQDTCompletionConstants.CompletionPrefixType.NORMAL;

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processFieldName(IField field, String token) {
        return null;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    public IAssistParser getParser() {
        if (this.fParser == null) {
            this.fParser = new XQDTAssistParser();
        }
        return this.fParser;
    }

    public void complete(ISourceModule sourceModule, int completionPosition, int pos) {
        this.fSourceModule = (org.eclipse.dltk.core.ISourceModule)sourceModule.getModelElement();
        this.fileName = sourceModule.getFileName();
        this.actualCompletionPosition = completionPosition;
        this.offset = pos;
        this.fLanguageLevel = this.getLanguageLevel(this.fSourceModule);
        this.fPrefix = this.extractPrefix(completionPosition);
        this.setSourceRange(this.actualCompletionPosition - this.fPrefix.length(), this.actualCompletionPosition);
        if (DEBUG) {
            System.out.println("Completion requested: " + this.fSourceModule.getElementName() + " (" + completionPosition + "," + pos + ",'" + this.fPrefix + "')");
        }
        this.requestor.beginReporting();
        this.reportKeywords();
        this.reportFunctions();
        this.reportEntities();
        this.requestor.endReporting();
    }

    protected int getLanguageLevel(org.eclipse.dltk.core.ISourceModule module) {
        return LanguageUtil.getLanguageLevel(module);
    }

    private void reportKeywords() {
        if (this.fPrefixType == IXQDTCompletionConstants.CompletionPrefixType.NORMAL && !this.requestor.isIgnored(2) && this.fPrefix.length() != 0) {
            String[] keywords = XQDTKeywords.findByPrefix(this.fPrefix, this.fLanguageLevel);
            int j = 0;
            while (j < keywords.length) {
                this.reportKeyword(keywords[j]);
                ++j;
            }
        }
    }

    private void reportKeyword(String name) {
        if (!this.requestor.isIgnored(2)) {
            this.noProposal = false;
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(name.toCharArray());
            proposal.setCompletion(name.toCharArray());
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(100000);
            this.requestor.accept(proposal);
        }
    }

    private void reportFunctions() {
        if (!(this.fPrefixType != IXQDTCompletionConstants.CompletionPrefixType.NORMAL && this.fPrefixType != IXQDTCompletionConstants.CompletionPrefixType.COLON || this.requestor.isIgnored(5))) {
            this.reportDeclaredFunctions();
            this.reportImportedFunctions();
            this.reportVendorImplicitImportedFunctions();
        }
    }

    private void reportDeclaredFunctions() {
        block2: {
            try {
                XQueryModule module = (XQueryModule)SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)this.fSourceModule);
                MethodDeclaration[] decls = module.getFunctions();
                this.buildFunctionCompletions(decls, null);
            }
            catch (Exception e) {
                if (!DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private void reportImportedFunctions() {
        try {
            XQueryModule module = (XQueryModule)SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)this.fSourceModule);
            ArrayList<XQueryModuleImport> importedModules = new ArrayList<XQueryModuleImport>(module.getImports());
            ArrayList<String> namespacePrefixes = new ArrayList<String>();
            for (XQueryModuleImport importedModule : importedModules) {
                namespacePrefixes.add(importedModule.getNamespacePrefix());
            }
            URI baseUri = this.getBaseUri();
            List<org.eclipse.dltk.core.ISourceModule> resolvedModules = this.resolveImports(baseUri, importedModules);
            if (resolvedModules == null) {
                return;
            }
            int i = 0;
            while (i < resolvedModules.size()) {
                ModuleDeclaration imported;
                org.eclipse.dltk.core.ISourceModule resolvedModule = resolvedModules.get(i);
                if (resolvedModule != null && (imported = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)resolvedModules.get(i))) instanceof XQueryLibraryModule) {
                    XQueryLibraryModule lib = (XQueryLibraryModule)imported;
                    XQueryModuleImport importedModule = (XQueryModuleImport)importedModules.get(i);
                    if (importedModule == null || lib.getNamespaceUri().getValue().equals(importedModule.getNamespaceUri().getValue())) {
                        this.buildFunctionCompletions(lib.getFunctions(), (String)namespacePrefixes.get(i));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportVendorImplicitImportedFunctions() {
        List<ImplicitImport> imports = ImplicitImportsRegistry.getImplicitImports(this.scriptProject);
        for (ImplicitImport imp : imports) {
            this.reportBuiltinFunctions(imp.getPrefix(), (IPath)new Path(imp.getPath()));
        }
    }

    private void reportBuiltinFunctions(String namespacePrefix, IPath builtinModulePath) {
        try {
            IModelElement element = this.scriptProject.findElement(builtinModulePath);
            if (element instanceof IExternalSourceModule) {
                ModuleDeclaration imported = SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)((org.eclipse.dltk.core.ISourceModule)element));
                if (imported instanceof XQueryLibraryModule) {
                    this.buildFunctionCompletions(((XQueryLibraryModule)imported).getFunctions(), namespacePrefix);
                }
            } else if (XQDTCorePlugin.DEBUG) {
                System.out.println("Unable to find builtin module " + builtinModulePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportEntities() {
        if (this.fPrefixType == IXQDTCompletionConstants.CompletionPrefixType.AMPERSAND) {
            int i = 0;
            while (i < XQDTKeywords.EMTITY_REFERECE_NAMES.length) {
                String name = XQDTKeywords.EMTITY_REFERECE_NAMES[i];
                if (name.startsWith(this.fPrefix)) {
                    this.reportEntity(XQDTKeywords.EMTITY_REFERECE_NAMES[i], XQDTKeywords.EMTITY_REFERECE_CHAR[i]);
                }
                ++i;
            }
        }
    }

    private void reportEntity(String name, String character) {
        this.noProposal = false;
        CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
        String completion = "&" + name + ";";
        String displayName = "&" + name + "; (" + character + ")";
        proposal.setName(displayName.toCharArray());
        proposal.setCompletion(completion.toCharArray());
        proposal.setReplaceRange(this.startPosition - this.offset - 1, this.endPosition - this.offset);
        proposal.setRelevance(100000);
        this.requestor.accept(proposal);
    }

    protected URI getBaseUri() {
        XQueryModule module = (XQueryModule)SourceParserUtil.getModuleDeclaration((org.eclipse.dltk.core.ISourceModule)this.fSourceModule);
        URI uri = module.getBaseUri();
        if (uri != null) {
            return uri;
        }
        return this.fSourceModule.getResource().getLocationURI();
    }

    private List<org.eclipse.dltk.core.ISourceModule> resolveImports(URI baseUri, List<XQueryModuleImport> importedModules) {
        ArrayList<URI> resolvedUris = new ArrayList<URI>(importedModules.size());
        IXQDTUriResolver resolver = this.getModuleResolver();
        if (resolver == null) {
            return null;
        }
        for (XQueryModuleImport imp : importedModules) {
            String uri = imp.getNamespaceUri().getValue();
            List<XQueryStringLiteral> hintList = imp.getHints();
            String[] hints = new String[hintList.size()];
            int i = 0;
            while (i < hintList.size()) {
                hints[i] = hintList.get(i).getValue();
                ++i;
            }
            URI resolvedUri = resolver.resolveModuleImport(baseUri, uri, hints);
            resolvedUris.add(resolvedUri);
        }
        ArrayList<org.eclipse.dltk.core.ISourceModule> resolved = new ArrayList<org.eclipse.dltk.core.ISourceModule>(resolvedUris.size());
        IScriptProject project = this.fSourceModule.getScriptProject();
        int i = 0;
        while (i < resolvedUris.size()) {
            URI resolvedUri = (URI)resolvedUris.get(i);
            if (resolvedUri != null) {
                resolved.add(resolver.locateSourceModule(resolvedUri, project));
            } else {
                resolved.add(null);
            }
            ++i;
        }
        return resolved;
    }

    protected IXQDTUriResolver getModuleResolver() {
        IProject project = this.fSourceModule.getScriptProject().getProject();
        return ResolverUtil.getProjectUriResolver(project);
    }

    private void buildFunctionCompletions(MethodDeclaration[] decls, String prefix) {
        if (decls == null) {
            return;
        }
        int i = 0;
        while (i < decls.length) {
            MethodDeclaration decl = decls[i];
            String name = decl.getName();
            if (prefix != null) {
                name = String.valueOf(prefix) + ":" + name.substring(name.indexOf(58) + 1);
            }
            if (name.startsWith(this.fPrefix) || name.substring(name.indexOf(58) + 1).startsWith(this.fPrefix)) {
                CompletionProposal proposal = this.createProposal(5, this.actualCompletionPosition);
                proposal.setName(name.toCharArray());
                proposal.setCompletion(name.toCharArray());
                List args = decl.getArguments();
                char[][] parameterNames = new char[args.size()][];
                int j = 0;
                while (j < args.size()) {
                    Argument arg = (Argument)args.get(j);
                    parameterNames[j] = ("$" + arg.getName()).toCharArray();
                    ++j;
                }
                proposal.setParameterNames((char[][])parameterNames);
                proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
                proposal.setRelevance(10000000);
                this.requestor.accept(proposal);
                this.noProposal = false;
            }
            ++i;
        }
    }

    protected String extractPrefix(int offset) {
        char[] content;
        try {
            content = this.fSourceModule.getSourceAsCharArray();
        }
        catch (ModelException modelException) {
            return "";
        }
        if (offset > content.length) {
            return "";
        }
        XQDTWordDetector wd = new XQDTWordDetector();
        String word = this.extractWord(content, offset, wd, true);
        if (this.fPrefixType == IXQDTCompletionConstants.CompletionPrefixType.COLON) {
            int prefixLen = word.length();
            String namespace = this.extractWord(content, offset - (prefixLen + 1), wd, false);
            word = String.valueOf(namespace) + ":" + word;
        }
        return word;
    }

    private String extractWord(char[] content, int offset, XQDTWordDetector wd, boolean checkPrefixPrefix) {
        int i = offset;
        char ch = '\u0000';
        while (i > 0) {
            ch = content[i - 1];
            if (!wd.isWordPart(ch)) break;
            --i;
        }
        if (checkPrefixPrefix) {
            this.fPrefixType = ch == ':' ? IXQDTCompletionConstants.CompletionPrefixType.COLON : (ch == '$' ? IXQDTCompletionConstants.CompletionPrefixType.DOLLAR : (ch == '&' ? IXQDTCompletionConstants.CompletionPrefixType.AMPERSAND : IXQDTCompletionConstants.CompletionPrefixType.NORMAL));
        }
        return new String(content, i, offset - i);
    }
}

