/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp;

import org.eclipse.wst.xquery.debug.dbgp.XmlElement;

public abstract class BreakpointElement
extends XmlElement {
    public BreakpointElement(String id, int hitValue, String hitCondition, int hitCount) {
        this(id, BreakpointState.ENABLED, hitValue, hitCondition, hitCount);
    }

    public BreakpointElement(String id, BreakpointState state, int hitValue, String hitCondition, int hitCount) {
        super("breakpoint");
        this.addAttribute("id", id);
        this.addAttribute("state", state.toString());
        this.addAttribute("hit_value", "" + hitValue);
        this.addAttribute("hit_condition", hitCondition);
        this.addAttribute("hit_count", "" + hitCount);
    }

    public abstract BreakpointType getType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakpointState {
        ENABLED("enabled"),
        DISABLED("disabled");

        private final String fState;

        private BreakpointState(String state) {
            this.fState = state;
        }

        public String toString() {
            return this.fState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakpointType {
        LINE,
        CALL,
        RETURN,
        EXCEPTION,
        CONDITIONAL,
        WATCH;

    }
}

