/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.xquery.launching.XQDTInterpreterInstallType;

public class XQDTBuildPathChangedListener
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        IModelElementDelta delta = event.getDelta();
        this.processDelta(delta);
    }

    private void processDelta(IModelElementDelta delta) {
        block21: {
            IModelElement element = delta.getElement();
            if (element.getElementType() == 2) {
                boolean hasNewBuildPath = false;
                if (delta.getKind() == 1) {
                    hasNewBuildPath = true;
                } else if ((delta.getFlags() & 0x20000) != 0) {
                    hasNewBuildPath = true;
                } else {
                    IModelElementDelta[] deltas;
                    IModelElementDelta[] iModelElementDeltaArray = deltas = delta.getAffectedChildren();
                    int n = deltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElementDelta childDelta = iModelElementDeltaArray[n2];
                        if ((childDelta.getFlags() & 0x40) != 0) {
                            hasNewBuildPath = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!hasNewBuildPath) {
                    return;
                }
                IScriptProject sProject = (IScriptProject)element;
                try {
                    IProjectFacet resolverFacet;
                    IInterpreterInstall interpreter = ScriptRuntime.getInterpreterInstall((IScriptProject)sProject);
                    IInterpreterInstallType installType = interpreter.getInterpreterInstallType();
                    if (!(installType instanceof XQDTInterpreterInstallType)) break block21;
                    String resolverFacetId = ((XQDTInterpreterInstallType)installType).getResolverFacetId();
                    final IProject project = sProject.getProject();
                    final IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                    final HashSet<IFacetedProject.Action> todoActions = new HashSet<IFacetedProject.Action>();
                    final boolean[] createFacets = new boolean[]{fProject == null && resolverFacetId != null};
                    if (fProject != null && resolverFacetId != null) {
                        resolverFacet = ProjectFacetsManager.getProjectFacet((String)resolverFacetId);
                        IProjectFacetVersion resolverFacetVersion = resolverFacet.getLatestVersion();
                        if (!fProject.hasProjectFacet(resolverFacet)) {
                            Set facets = fProject.getProjectFacets();
                            for (IProjectFacetVersion facet : facets) {
                                todoActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facet, null));
                            }
                            todoActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, resolverFacetVersion, null));
                        }
                    } else if (fProject != null && resolverFacetId == null) {
                        Set facets = fProject.getProjectFacets();
                        for (IProjectFacetVersion facet : facets) {
                            if (!facet.getProjectFacet().getCategory().getId().equals("uriResolverCategory")) continue;
                            todoActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, facet, null));
                        }
                    } else if (fProject == null && resolverFacetId != null) {
                        resolverFacet = ProjectFacetsManager.getProjectFacet((String)resolverFacetId);
                        IProjectFacetVersion resolverFacetVersion = resolverFacet.getLatestVersion();
                        todoActions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, resolverFacetVersion, null));
                    }
                    if (todoActions.size() != 0) {
                        WorkspaceJob job = new WorkspaceJob("Configuring project URI resolver"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                IFacetedProject proj = fProject;
                                if (createFacets[0]) {
                                    proj = ProjectFacetsManager.create((IProject)project, (boolean)true, null);
                                }
                                proj.modify(todoActions, monitor);
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                IModelElementDelta[] deltas;
                IModelElementDelta[] iModelElementDeltaArray = deltas = delta.getAffectedChildren();
                int n = deltas.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelElementDelta childDelta = iModelElementDeltaArray[n3];
                    this.processDelta(childDelta);
                    ++n3;
                }
            }
        }
    }
}

