/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.core.parser.visitors;

import java.util.List;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.wst.xquery.core.model.ast.XQueryFunctionDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryModuleDecl;
import org.eclipse.wst.xquery.core.model.ast.XQueryParam;
import org.eclipse.wst.xquery.core.model.ast.XQueryQueryBody;
import org.eclipse.wst.xquery.core.model.ast.XQueryVarDecl;
import org.eclipse.wst.xquery.core.model.compiler.IXQDTSourceElementRequestor;

public class XQDTSourceElementRequestorVisitor
extends SourceElementRequestVisitor {
    public XQDTSourceElementRequestorVisitor(ISourceElementRequestor requesor) {
        super(requesor);
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        XQueryFunctionDecl function = (XQueryFunctionDecl)method;
        List args = function.getArguments();
        String[] parameterNames = new String[args.size()];
        String[] parameterTypes = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            XQueryParam param = (XQueryParam)((Object)args.get(a));
            parameterNames[a] = param.getName();
            parameterTypes[a] = param.getType();
            ++a;
        }
        IXQDTSourceElementRequestor.FunctionInfo fi = new IXQDTSourceElementRequestor.FunctionInfo();
        fi.parameterNames = parameterNames;
        fi.parameterTypes = parameterTypes;
        fi.name = function.getName();
        fi.modifiers = function.getModifiers();
        fi.nameSourceStart = function.getNameStart();
        fi.nameSourceEnd = function.getNameEnd() - 1;
        fi.declarationStart = function.sourceStart();
        fi.isExternal = function.isExternal();
        this.fRequestor.enterMethod((ISourceElementRequestor.MethodInfo)fi);
        this.fInMethod = true;
        this.fCurrentMethod = function;
        return true;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        XQueryFunctionDecl function = (XQueryFunctionDecl)method;
        this.fRequestor.exitMethod(function.sourceEnd());
        this.fInMethod = false;
        this.fCurrentMethod = null;
        return true;
    }

    public boolean visit(XQueryVarDecl varDecl) throws Exception {
        IXQDTSourceElementRequestor.VariableInfo vi = new IXQDTSourceElementRequestor.VariableInfo();
        vi.name = varDecl.getName();
        vi.modifiers = varDecl.getModifiers();
        vi.nameSourceStart = varDecl.getNameStart();
        vi.nameSourceEnd = varDecl.getNameEnd() - 1;
        vi.declarationStart = varDecl.sourceStart();
        vi.isExternal = varDecl.isExternal();
        vi.isConstant = varDecl.isConstant();
        this.fRequestor.enterField((ISourceElementRequestor.FieldInfo)vi);
        return true;
    }

    public boolean endvisit(XQueryVarDecl varDecl) throws Exception {
        this.fRequestor.exitField(varDecl.sourceEnd());
        return true;
    }

    public boolean visit(XQueryModuleDecl moduleDecl) throws Exception {
        this.fRequestor.acceptPackage(moduleDecl.sourceStart(), moduleDecl.sourceEnd(), moduleDecl.getNamespacePrefix().toCharArray());
        return true;
    }

    public boolean endvisit(XQueryModuleDecl moduleDecl) throws Exception {
        return true;
    }

    public boolean visit(XQueryQueryBody queryBody) throws Exception {
        return true;
    }

    public boolean endvisit(XQueryQueryBody queryBody) throws Exception {
        return true;
    }

    public boolean visit(Statement statement) throws Exception {
        switch (statement.getKind()) {
            case 3: {
                return this.visit((XQueryVarDecl)statement);
            }
            case 10001: {
                return this.visit((XQueryModuleDecl)statement);
            }
        }
        return super.visit(statement);
    }

    public boolean endvisit(Statement statement) throws Exception {
        switch (statement.getKind()) {
            case 3: {
                return this.endvisit((XQueryVarDecl)statement);
            }
            case 10001: {
                return this.endvisit((XQueryModuleDecl)statement);
            }
        }
        return super.endvisit(statement);
    }

    public boolean visit(Expression expression) throws Exception {
        switch (expression.getKind()) {
            case 10005: {
                return this.visit((XQueryQueryBody)expression);
            }
        }
        return super.visit(expression);
    }

    public boolean endvisit(Expression expression) throws Exception {
        switch (expression.getKind()) {
            case 10005: {
                return this.endvisit((XQueryQueryBody)expression);
            }
        }
        return super.endvisit(expression);
    }
}

