/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.wst.xquery.internal.ui.text.IXQDTPartitions;
import org.eclipse.wst.xquery.internal.ui.text.rules.ISemanticRule;
import org.eclipse.wst.xquery.internal.ui.text.rules.SemanticMultiEndMultiLineRule;
import org.eclipse.wst.xquery.internal.ui.text.rules.SemanticMultiLineRule;
import org.eclipse.wst.xquery.internal.ui.text.rules.XQDTPartitioner;

public class XQDTPartitionScanner
extends RuleBasedPartitionScanner
implements IXQDTPartitions {
    public XQDTPartitionScanner() {
        Token xmlCDATA = new Token((Object)"__xqdt_xml_cdata");
        Token xmlComment = new Token((Object)"__xqdt_xml_coment");
        Token comment = new Token((Object)"__xqdt_comment");
        Token string = new Token((Object)"__xqdt_string");
        Token elemContent = new Token((Object)"__xqdt_xml_element_content");
        Token attrValue = new Token((Object)"__xqdt_xml_attribute_value");
        ArrayList<ISemanticRule> rules = new ArrayList<ISemanticRule>();
        rules.add(new SemanticMultiLineRule("'", "'", (IToken)string, '\u0000', true));
        rules.add(new SemanticMultiLineRule("\"", "\"", (IToken)string, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, ">", new String[]{"<", "{"}, (IToken)elemContent, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, "}", new String[]{"<", "{"}, (IToken)elemContent, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, "\"", new String[]{"{", "\""}, (IToken)attrValue, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, "}", new String[]{"\"", "{"}, (IToken)attrValue, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, "'", new String[]{"{", "'"}, (IToken)attrValue, '\u0000', true));
        rules.add(new SemanticMultiEndMultiLineRule(true, "}", new String[]{"'", "{"}, (IToken)attrValue, '\u0000', true));
        rules.add((ISemanticRule)new MultiLineRule("(:", ":)", (IToken)comment, '\u0000', true));
        rules.add((ISemanticRule)new MultiLineRule("<!--", "-->", (IToken)xmlComment, '\u0000', true));
        rules.add((ISemanticRule)new MultiLineRule("<![CDATA[", "]]>", (IToken)xmlCDATA, '\u0000', true));
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    public IToken nextToken() {
        if (this.fRules == null) {
            return super.nextToken();
        }
        this.fColumn = -1;
        boolean resume = false;
        this.fTokenOffset = resume ? this.fPartitionOffset : this.fOffset;
        String offsetPartition = this.getOffsetPartitionType();
        if (XQDTPartitionScanner.isSemanticPartitionType(offsetPartition)) {
            int i = 0;
            while (i < this.fRules.length) {
                IToken token;
                IPredicateRule rule = (IPredicateRule)this.fRules[i];
                if (this.fRules[i] instanceof ISemanticRule && ((ISemanticRule)this.fRules[i]).getContentType() == offsetPartition && !(token = rule.evaluate((ICharacterScanner)this, resume)).isUndefined()) {
                    return token;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fRules.length) {
                IToken token;
                IPredicateRule rule = (IPredicateRule)this.fRules[i];
                if (!(rule instanceof ISemanticRule) && !(token = rule.evaluate((ICharacterScanner)this, resume)).isUndefined()) {
                    return token;
                }
                ++i;
            }
        }
        if (resume) {
            this.fOffset = this.fPartitionOffset;
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    public static boolean isSemanticPartitionType(String type) {
        return Arrays.binarySearch(IXQDTPartitions.XQDT_SEMANTIC_PARTITION_TYPES, type) >= 0;
    }

    private String getOffsetPartitionType() {
        ITypedRegion partition;
        block3: {
            partition = null;
            try {
                if (this.fOffset <= this.fDocument.getLength() && ((IDocumentExtension3)this.fDocument).getDocumentPartitioner("__xqdt_partitioning") != null) break block3;
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        XQDTPartitioner partitioner = (XQDTPartitioner)((IDocumentExtension3)this.fDocument).getDocumentPartitioner("__xqdt_partitioning");
        partition = partitioner.getPartitionFromDocument(this.fOffset);
        return partition.getType();
    }

    public boolean acceptsStartSequence(char[] sequence) {
        return this.fOffset >= sequence.length;
    }
}

