/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.text.rules;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xquery.core.XQDTCorePlugin;
import org.eclipse.wst.xquery.core.model.ast.IXQDTSemanticPositionProvider;
import org.eclipse.wst.xquery.core.model.ast.XQueryModule;
import org.eclipse.wst.xquery.internal.ui.text.XQDTPartitionScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XQDTPartitioner
extends FastPartitioner
implements IElementChangedListener {
    private ScriptEditor fEditor;
    private IPresentationReconciler fPresentationReconciler;
    private int fLastEditedOffset;

    public XQDTPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
    }

    public void setEditor(ScriptEditor editor, IPreferenceStore preferences) {
        this.fEditor = editor;
        ScriptTextTools textTools = this.fEditor.getTextTools();
        ScriptSourceViewerConfiguration config = textTools.createSourceViewerConfiguraton(preferences, (ITextEditor)editor);
        this.fPresentationReconciler = config.getPresentationReconciler(editor.getScriptSourceViewer());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion documentChanged2(DocumentEvent e) {
        try {
            this.fLastEditedOffset = e.getOffset();
            Assert.isTrue((boolean)(e.getDocument() == this.fDocument));
            category = this.getPositions();
            line = this.fDocument.getLineInformationOfOffset(e.getOffset());
            reparseStart = line.getOffset();
            extension = null;
            if (this.fDocument instanceof IDocumentExtension3) {
                extension = (IDocumentExtension3)this.fDocument;
                offsetPartition = extension.getPartition("__xqdt_partitioning", e.fOffset, false);
                reparseStart = offsetPartition.getOffset();
            }
            partitionStart = -1;
            contentType = null;
            newLength = e.getText() == null ? 0 : e.getText().length();
            positionCategory = this.getManagingPositionCategories()[0];
            first = this.fDocument.computeIndexInCategory(positionCategory, reparseStart);
            if (first > 0) {
                partition = (TypedPosition)category[first - 1];
                if (partition.includes(reparseStart)) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    if (e.getOffset() == partition.getOffset() + partition.getLength()) {
                        reparseStart = partitionStart;
                    }
                    --first;
                } else if (reparseStart == e.getOffset() && reparseStart == partition.getOffset() + partition.getLength()) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    reparseStart = partitionStart;
                    --first;
                } else {
                    partitionStart = partition.getOffset() + partition.getLength();
                    contentType = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(e);
            i = first;
            while (i < category.length) {
                p = category[i];
                if (p.isDeleted) {
                    this.rememberDeletedOffset(e.getOffset());
                    break;
                }
                ++i;
            }
            this.clearPositionCache();
            category = this.getPositions();
            this.fScanner.setPartialRange(this.fDocument, reparseStart, this.fDocument.getLength() - reparseStart, contentType, partitionStart);
            behindLastScannedPosition = reparseStart;
            token = this.fScanner.nextToken();
            if (true) ** GOTO lbl83
        }
        catch (BadPositionCategoryException v0) {
            this.clearPositionCache();
            return this.createRegion();
        }
        catch (BadLocationException v1) {
            return this.createRegion();
            catch (Exception x) {
                x.printStackTrace();
                this.clearPositionCache();
                return this.createRegion();
            }
            finally {
                this.clearPositionCache();
            }
        }
lbl67:
        // 1 sources

        while (true) {
            this.clearPositionCache();
            return var18_21;
        }
        {
            do {
                ++first;
                if (true) ** GOTO lbl81
                block16: do {
                    try {
                        this.fDocument.addPosition(positionCategory, (Position)new TypedPosition(start, length, contentType));
                        this.rememberRegion(start, length);
                    }
                    catch (BadPositionCategoryException v2) {
                    }
                    catch (BadLocationException v3) {}
                    token = this.fScanner.nextToken();
lbl83:
                    // 2 sources

                    while (true) {
                        block29: {
                            if (!token.isEOF()) break block29;
                            first = this.fDocument.computeIndexInCategory(positionCategory, behindLastScannedPosition);
                            this.clearPositionCache();
                            category = this.getPositions();
                            if (true) ** GOTO lbl113
                        }
                        contentType = this.getTokenContentType(token);
                        if (this.isSupportedContentType(contentType)) break;
                        token = this.fScanner.nextToken();
                    }
                    start = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    behindLastScannedPosition = start + length;
                    lastScannedPosition = behindLastScannedPosition - 1;
                    while (first < category.length) {
                        p = (TypedPosition)category[first];
                        if (lastScannedPosition < p.offset + p.length && (!p.overlapsWith(start, length) || this.fDocument.containsPosition(positionCategory, start, length) && contentType.equals(p.getType()))) continue block16;
                        this.rememberRegion(p.offset, p.length);
                        this.fDocument.removePosition(positionCategory, (Position)p);
                        ++first;
                    }
                } while (!this.fDocument.containsPosition(positionCategory, start, length));
            } while (lastScannedPosition < e.getOffset() + newLength);
            var18_21 = this.createRegion();
            ** continue;
            do {
                p = (TypedPosition)category[first++];
                this.fDocument.removePosition(positionCategory, (Position)p);
                this.rememberRegion(p.offset, p.length);
lbl113:
                // 2 sources

            } while (first < category.length);
        }
        this.clearPositionCache();
        return this.createRegion();
    }

    public void elementChanged(ElementChangedEvent event) {
        IModelElement source = event.getDelta().getElement();
        if (source == this.fEditor.getInputModelElement() && event.getDelta().getElement() instanceof ISourceModule) {
            ArrayList<ISourceRange> ranges;
            XQueryModule xqModule;
            block20: {
                ISourceModule module = (ISourceModule)event.getDelta().getElement();
                xqModule = (XQueryModule)SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                ranges = new ArrayList<ISourceRange>();
                if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
                    System.out.println("Affected Children: " + event.getDelta().getAffectedChildren().length);
                }
                IModelElementDelta[] iModelElementDeltaArray = event.getDelta().getAffectedChildren();
                int n = iModelElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block19: {
                        IModelElementDelta delta = iModelElementDeltaArray[n2];
                        if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
                            System.out.println("Change kind: " + delta.getKind() + "; " + delta.getElement());
                        }
                        if ((delta.getKind() == 1 || delta.getKind() == 4) && delta.getElement() instanceof IMethod) {
                            IMethod function = (IMethod)delta.getElement();
                            try {
                                ISourceRange range = function.getSourceRange();
                                if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
                                    System.out.println("Range start: " + range.getOffset());
                                    System.out.println("Range end: " + (range.getOffset() + range.getLength()));
                                }
                                ranges.add(range);
                            }
                            catch (ModelException me) {
                                if (!XQDTCorePlugin.DEBUG) break block19;
                                me.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
                try {
                    if (ranges.size() == 0) {
                        IModelElement element = null;
                        if (this.fLastEditedOffset == 0) {
                            ranges.add(module.getSourceRange());
                        } else {
                            element = module.getElementAt(this.fLastEditedOffset);
                            if (element != null && element instanceof ISourceReference) {
                                ranges.add(((ISourceReference)element).getSourceRange());
                            }
                        }
                    } else {
                        boolean allModule = false;
                        for (ISourceRange sourceRange : ranges) {
                            if (this.fLastEditedOffset < sourceRange.getOffset()) {
                                allModule = true;
                                break;
                            }
                            if (this.fLastEditedOffset < sourceRange.getOffset() + sourceRange.getLength()) break;
                        }
                        if (allModule) {
                            ranges.clear();
                            ranges.add(module.getSourceRange());
                        }
                    }
                }
                catch (ModelException e) {
                    if (!XQDTCorePlugin.DEBUG) break block20;
                    e.printStackTrace();
                }
            }
            if (xqModule != null && ranges.size() > 0) {
                this.updateSemanticPartitions(xqModule, ranges);
            }
        }
    }

    private void rememberRegion(int offset, int length) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = offset;
        } else if (offset < this.fStartOffset) {
            this.fStartOffset = offset;
        }
        int endOffset = offset + length;
        if (this.fEndOffset == -1) {
            this.fEndOffset = endOffset;
        } else if (endOffset > this.fEndOffset) {
            this.fEndOffset = endOffset;
        }
    }

    private void rememberDeletedOffset(int offset) {
        this.fDeleteOffset = offset;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int offset = Math.min(this.fDeleteOffset, this.fStartOffset);
        int endOffset = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(offset, endOffset - offset);
    }

    public void updateSemanticPartitions(XQueryModule module, List<ISourceRange> ranges) {
        String category = this.getContentTypeCategory();
        if (category == null) {
            return;
        }
        List<Position> removedPositions = this.deleteSemanticPartitions(category, ranges);
        List strings = module.getStringLiterals();
        List<Position> addedPositions = this.updatePartitions(strings.toArray(new IXQDTSemanticPositionProvider[strings.size()]), category, "__xqdt_string", ranges);
        List contents = module.getXmlElementContentText();
        addedPositions.addAll(this.updatePartitions(contents.toArray(new IXQDTSemanticPositionProvider[contents.size()]), category, "__xqdt_xml_element_content", ranges));
        List values = module.getXmlAttributeValuesText();
        addedPositions.addAll(this.updatePartitions(values.toArray(new IXQDTSemanticPositionProvider[values.size()]), category, "__xqdt_xml_attribute_value", ranges));
        if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
            System.out.println("Removed positions: " + removedPositions.size());
            System.out.println("Added positions: " + addedPositions.size());
        }
        if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
            System.out.println(String.valueOf(Calendar.getInstance().getTimeInMillis()) + ": start applyPositions");
        }
        this.applyPositions(addedPositions, removedPositions);
        if (XQDTCorePlugin.DEBUG_DOCUMENT_PARTITIONER) {
            System.out.println(String.valueOf(Calendar.getInstance().getTimeInMillis()) + ": end applyPositions");
        }
    }

    private void applyPositions(List<Position> addedPositions, List<Position> removedPositions) {
        this.clearPositionCache();
        final TextPresentation textPresentation = this.createPresentation(addedPositions, removedPositions);
        if (textPresentation == null) {
            return;
        }
        if (this.fEditor == null) {
            return;
        }
        IWorkbenchPartSite site = this.fEditor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (textPresentation != null) {
                    System.out.println("changeTextPresentation2");
                    XQDTPartitioner.this.fEditor.getScriptSourceViewer().changeTextPresentation(textPresentation, false);
                } else {
                    System.out.println("invalidateTextPresentation");
                    XQDTPartitioner.this.fEditor.getScriptSourceViewer().invalidateTextPresentation();
                }
            }
        });
    }

    public TextPresentation createPresentation(List<Position> addedPositions, List<Position> removedPositions) {
        int offset;
        Position position;
        ISourceViewer sourceViewer = this.fEditor.getScriptSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return null;
        }
        int minStart = Integer.MAX_VALUE;
        int maxEnd = Integer.MIN_VALUE;
        int i = 0;
        int n = removedPositions.size();
        while (i < n) {
            position = removedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        i = 0;
        n = addedPositions.size();
        while (i < n) {
            position = addedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        if (minStart < maxEnd && this.fPresentationReconciler instanceof ScriptPresentationReconciler) {
            return ((ScriptPresentationReconciler)this.fPresentationReconciler).createRepairDescription((IRegion)new Region(minStart, maxEnd - minStart), document);
        }
        return null;
    }

    private String getContentTypeCategory() {
        String[] stringArray = this.fDocument.getPositionCategories();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (category.startsWith("__content_types_category")) {
                return category;
            }
            ++n2;
        }
        return null;
    }

    private List<Position> deleteSemanticPartitions(String category, List<ISourceRange> ranges) {
        ArrayList<Position> positions = new ArrayList<Position>();
        int rangeIndex = 0;
        if (ranges.size() == 0) {
            return positions;
        }
        ISourceRange range = ranges.get(rangeIndex);
        try {
            Position[] positionArray = this.fDocument.getPositions(category);
            int n = positionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                if (position.getOffset() >= range.getOffset()) {
                    if (position.getOffset() > range.getOffset() + range.getLength()) {
                        while (++rangeIndex < ranges.size() && position.getOffset() > range.getOffset() + range.getLength()) {
                            range = ranges.get(rangeIndex);
                        }
                        if (rangeIndex == ranges.size()) {
                            return positions;
                        }
                    }
                    if (XQDTPartitionScanner.isSemanticPartitionType(((TypedPosition)position).getType())) {
                        this.fDocument.removePosition(category, position);
                        positions.add(position);
                    }
                }
                ++n2;
            }
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
        return positions;
    }

    private List<Position> updatePartitions(IXQDTSemanticPositionProvider[] providers, String category, String positionType, List<ISourceRange> ranges) {
        ArrayList<Position> positions = new ArrayList<Position>();
        int rangeIndex = 0;
        if (ranges.size() == 0) {
            return positions;
        }
        ISourceRange range = ranges.get(rangeIndex);
        IXQDTSemanticPositionProvider[] iXQDTSemanticPositionProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            IXQDTSemanticPositionProvider provider = iXQDTSemanticPositionProviderArray[n2];
            TypedPosition position = provider.getTypedPosition(positionType);
            if (position.getOffset() >= range.getOffset()) {
                if (position.getOffset() > range.getOffset() + range.getLength()) {
                    while (++rangeIndex < ranges.size() && position.getOffset() < range.getOffset()) {
                        range = ranges.get(rangeIndex);
                    }
                    if (rangeIndex == ranges.size()) {
                        return positions;
                    }
                }
                try {
                    this.fDocument.addPosition(category, (Position)position);
                    positions.add((Position)position);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                catch (BadPositionCategoryException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return positions;
    }

    public ITypedRegion getPartitionFromDocument(int offset) {
        try {
            String positionCategory = this.getManagingPositionCategories()[0];
            Position[] category = this.fDocument.getPositions(positionCategory);
            if (category == null || category.length == 0) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            int index = this.fDocument.computeIndexInCategory(positionCategory, offset);
            if (index < category.length) {
                TypedPosition next = (TypedPosition)category[index];
                if (offset == next.offset) {
                    return new TypedRegion(next.getOffset(), next.getLength(), next.getType());
                }
                if (index == 0) {
                    return new TypedRegion(0, next.offset, "__dftl_partition_content_type");
                }
                TypedPosition previous = (TypedPosition)category[index - 1];
                if (previous.includes(offset)) {
                    return new TypedRegion(previous.getOffset(), previous.getLength(), previous.getType());
                }
                int endOffset = previous.getOffset() + previous.getLength();
                return new TypedRegion(endOffset, next.getOffset() - endOffset, "__dftl_partition_content_type");
            }
            TypedPosition previous = (TypedPosition)category[category.length - 1];
            if (previous.includes(offset)) {
                return new TypedRegion(previous.getOffset(), previous.getLength(), previous.getType());
            }
            int endOffset = previous.getOffset() + previous.getLength();
            return new TypedRegion(endOffset, this.fDocument.getLength() - endOffset, "__dftl_partition_content_type");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
        return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
    }
}

