/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardSecondPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.xquery.internal.ui.preferences.XQDTBuildPathsBlock;
import org.eclipse.wst.xquery.ui.XQDTUIPlugin;

public class XQDTNewProjectWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_ID = "org.eclipse.wst.xquery.ui.wizards.newproject";
    private ProjectWizardFirstPage fFirstPage;
    private ProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public XQDTNewProjectWizard() {
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New XQuery Project");
    }

    public void addPages() {
        this.fFirstPage = new ProjectWizardFirstPage(){

            protected boolean interpeterRequired() {
                return true;
            }

            protected ProjectWizardFirstPage.IInterpreterGroup createInterpreterGroup(Composite parent) {
                return new XQDTInterpreterGroup(parent);
            }

            final class XQDTInterpreterGroup
            extends ProjectWizardFirstPage.AbstractInterpreterGroup {
                public XQDTInterpreterGroup(Composite composite) {
                    super((ProjectWizardFirstPage)this, composite);
                }

                protected String getCurrentLanguageNature() {
                    return "org.eclipse.wst.xquery.core.nature";
                }

                protected String getIntereprtersPreferencePageId() {
                    return "org.eclipse.wst.xquery.preferences.interpreters";
                }
            }
        };
        this.fFirstPage.setTitle("Create a XQuery project");
        this.fFirstPage.setDescription("Create a XQuery project in the workspace or in an external location");
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new ProjectWizardSecondPage(this.fFirstPage){

            protected IPreferenceStore getPreferenceStore() {
                return XQDTUIPlugin.getDefault().getPreferenceStore();
            }

            protected BuildpathsBlock createBuildpathBlock(IStatusChangeListener listener) {
                return new XQDTBuildPathsBlock((IRunnableContext)new BusyIndicatorRunnableContext(), listener, 0, this.useNewSourcePage(), null);
            }

            protected String getScriptNature() {
                return "org.eclipse.wst.xquery.core.nature";
            }
        };
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getScriptProject().getProject());
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }
}

