/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeToken<T> {
    final Class<? super T> rawType;
    final Type type;

    protected TypeToken() {
        this.type = TypeToken.getSuperclassTypeParameter(this.getClass());
        this.rawType = TypeToken.getRawType(this.type);
    }

    private TypeToken(Type type) {
        this.rawType = TypeToken.getRawType(TypeToken.nonNull(type, "type"));
        this.type = type;
    }

    private static <T> T nonNull(T o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
        return o;
    }

    static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    static TypeToken<?> fromSuperclassTypeParameter(Class<?> subclass) {
        return new SimpleTypeToken(subclass);
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
            throw TypeToken.buildUnexpectedTypeError(rawType, Class.class);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Object rawArrayType = Array.newInstance(TypeToken.getRawType(genericArrayType.getGenericComponentType()), 0);
            return rawArrayType.getClass();
        }
        throw TypeToken.buildUnexpectedTypeError(type, ParameterizedType.class, GenericArrayType.class);
    }

    public Class<? super T> getRawType() {
        return this.rawType;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isAssignableFrom(Class<?> cls) {
        return this.isAssignableFrom((Type)cls);
    }

    public boolean isAssignableFrom(Type from) {
        if (from == null) {
            return false;
        }
        if (this.type.equals(from)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom(TypeToken.getRawType(from));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(from, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (this.type instanceof GenericArrayType) {
            return this.rawType.isAssignableFrom(TypeToken.getRawType(from)) && TypeToken.isAssignableFrom(from, (GenericArrayType)this.type);
        }
        throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    public boolean isAssignableFrom(TypeToken<?> token) {
        return this.isAssignableFrom(token.getType());
    }

    private static boolean isAssignableFrom(Type from, GenericArrayType to) {
        Type toGenericComponentType = to.getGenericComponentType();
        if (toGenericComponentType instanceof ParameterizedType) {
            Type t = from;
            if (from instanceof GenericArrayType) {
                t = ((GenericArrayType)from).getGenericComponentType();
            } else if (from instanceof Class) {
                Class<?> classType = (Class<?>)from;
                while (classType.isArray()) {
                    classType = classType.getComponentType();
                }
                t = classType;
            }
            return TypeToken.isAssignableFrom(t, (ParameterizedType)toGenericComponentType, new HashMap<String, Type>());
        }
        return true;
    }

    private static boolean isAssignableFrom(Type from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from == null) {
            return false;
        }
        if (to.equals(from)) {
            return true;
        }
        Class<?> clazz = TypeToken.getRawType(from);
        ParameterizedType ptype = null;
        if (from instanceof ParameterizedType) {
            ptype = (ParameterizedType)from;
        }
        if (ptype != null) {
            Type[] tArgs = ptype.getActualTypeArguments();
            TypeVariable<Class<?>>[] tParams = clazz.getTypeParameters();
            int i = 0;
            while (i < tArgs.length) {
                Type arg = tArgs[i];
                TypeVariable<Class<?>> var = tParams[i];
                while (arg instanceof TypeVariable) {
                    TypeVariable v = (TypeVariable)arg;
                    arg = typeVarMap.get(v.getName());
                }
                typeVarMap.put(var.getName(), arg);
                ++i;
            }
            if (TypeToken.typeEquals(ptype, to, typeVarMap)) {
                return true;
            }
        }
        Type[] typeArray = clazz.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type itype = typeArray[n2];
            if (TypeToken.isAssignableFrom(itype, to, new HashMap<String, Type>(typeVarMap))) {
                return true;
            }
            ++n2;
        }
        Type sType = clazz.getGenericSuperclass();
        return TypeToken.isAssignableFrom(sType, to, new HashMap<String, Type>(typeVarMap));
    }

    private static boolean typeEquals(ParameterizedType from, ParameterizedType to, Map<String, Type> typeVarMap) {
        if (from.getRawType().equals(to.getRawType())) {
            Type[] fromArgs = from.getActualTypeArguments();
            Type[] toArgs = to.getActualTypeArguments();
            int i = 0;
            while (i < fromArgs.length) {
                if (!TypeToken.matches(fromArgs[i], toArgs[i], typeVarMap)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean matches(Type from, Type to, Map<String, Type> typeMap) {
        if (to.equals(from)) {
            return true;
        }
        if (from instanceof TypeVariable) {
            return to.equals(typeMap.get(((TypeVariable)from).getName()));
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeToken)) {
            return false;
        }
        TypeToken t = (TypeToken)o;
        return this.type.equals(t.type);
    }

    public String toString() {
        return this.type instanceof Class ? ((Class)this.type).getName() : this.type.toString();
    }

    private static AssertionError buildUnexpectedTypeError(Type token, Class<?> ... expected) {
        StringBuilder exceptionMessage = new StringBuilder("Unexpected type. Expected one of: ");
        Class<?>[] classArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            exceptionMessage.append(clazz.getName()).append(", ");
            ++n2;
        }
        exceptionMessage.append("but got: ").append(token.getClass().getName()).append(", for type token: ").append(token.toString()).append('.');
        return new AssertionError((Object)exceptionMessage.toString());
    }

    public static TypeToken<?> get(Type type) {
        return new SimpleTypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new SimpleTypeToken(type);
    }

    /* synthetic */ TypeToken(Type type, TypeToken typeToken) {
        this(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleTypeToken<T>
    extends TypeToken<T> {
        public SimpleTypeToken(Type type) {
            super(type, null);
        }
    }
}

