/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.wst.xquery.core.IXQDTUriResolver;

public class XQDTUriResolver
implements IXQDTUriResolver {
    public URI resolveModuleImport(URI baseUri, String uri, String[] hints) {
        if (hints.length == 0) {
            return this.resolveUri(baseUri, uri);
        }
        int i = 0;
        while (i < hints.length) {
            URI u = this.resolveUri(baseUri, hints[i]);
            if (u != null) {
                return u;
            }
            ++i;
        }
        return this.resolveUri(baseUri, uri);
    }

    public URI resolveUri(URI baseUri, String uriString) {
        try {
            return baseUri.resolve(uriString);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    public ISourceModule locateSourceModule(URI uri, IScriptProject project) {
        Path path;
        IPath projectLoc = project.getProject().getLocation();
        if (projectLoc.isPrefixOf((IPath)(path = new Path(uri.getPath())))) {
            File f;
            IPath packageAbolutePath = path.removeLastSegments(1);
            IPath packageRelativePath = packageAbolutePath.removeFirstSegments(projectLoc.segmentCount()).makeRelative().setDevice(null);
            IScriptProject folder = null;
            if (packageRelativePath.segmentCount() == 0) {
                folder = project;
            } else {
                try {
                    folder = project.findScriptFolder(packageRelativePath.makeAbsolute());
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
            if (folder != null && (f = new File(path.toOSString())).exists()) {
                return DLTKCore.createSourceModuleFrom((IFile)((IContainer)folder.getResource()).getFile((IPath)new Path(path.lastSegment())));
            }
        }
        return null;
    }
}

