/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.core.utils;

import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtil {
    public static IPath makePathRelativeTo(IPath path, IPath base) {
        String device = path.getDevice();
        String[] segments = path.segments();
        if (!(device == base.getDevice() || device != null && device.equalsIgnoreCase(base.getDevice()))) {
            return path;
        }
        int commonLength = path.matchingFirstSegments(base);
        int differenceLength = base.segmentCount() - commonLength;
        int newSegmentLength = differenceLength + path.segmentCount() - commonLength;
        if (newSegmentLength == 0) {
            return Path.EMPTY;
        }
        Object[] newSegments = new String[newSegmentLength];
        Arrays.fill(newSegments, 0, differenceLength, "..");
        System.arraycopy(segments, commonLength, newSegments, differenceLength, newSegmentLength - differenceLength);
        Path resPath = new Path(null, "");
        Object[] objectArray = newSegments;
        int n = newSegments.length;
        int n2 = 0;
        while (n2 < n) {
            Object string = objectArray[n2];
            resPath = resPath.append((String)string);
            ++n2;
        }
        if (path.hasTrailingSeparator()) {
            resPath.addTrailingSeparator();
        }
        return resPath;
    }
}

