/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.dbgp.internal.DbgpTermination;
import org.eclipse.wst.xquery.debug.dbgp.IDebuggerEngine;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.IDebugEventListener;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.MessageReader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ProtocolException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.SocketClientConnection;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.SocketServerConnection;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractCommandMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ClearMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.CommandNotImplementedException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.EvaluateMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.EvaluatedMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.FramesMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.InvalidCommandException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.MessageFactory;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.MessageFormatException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.ReplyMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.SetMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.StepMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.VariablesMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.VariablesPayload;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.QueryLocation;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZorbaDebuggerEngine
extends DbgpTermination
implements IDebuggerEngine {
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_RETURN = 3;
    private boolean fTerminated = false;
    private boolean fSuspended = false;
    private SocketClientConnection fRequestConnection;
    private SocketServerConnection fEventConnection;
    private MessageReader fReplyReader;
    private MessageReader fEventReader;
    private EventListener fEventListener;
    private LinkedList<AbstractMessage> fReceivedEvents = new LinkedList();
    private ListenerList fEventListeners = new ListenerList(1);
    private Map<Integer, IDebugEventListener> fEvalEventListenerMap = new HashMap<Integer, IDebugEventListener>();

    public ZorbaDebuggerEngine(int requestPort, int eventPort) {
        this.fRequestConnection = new SocketClientConnection(requestPort);
        this.fEventConnection = new SocketServerConnection(eventPort);
        this.fEventListener = new EventListener();
    }

    private void notifyListeners(AbstractCommandMessage event) {
        if (event instanceof EvaluatedMessage) {
            EvaluatedMessage evaled = (EvaluatedMessage)event;
            int key = evaled.getExprId();
            IDebugEventListener listener = this.fEvalEventListenerMap.get(new Integer(key));
            if (listener != null) {
                listener.handleDebugEvent(event);
            } else {
                IDebugEventListener[] listeners = new IDebugEventListener[this.fEvalEventListenerMap.size()];
                this.fEvalEventListenerMap.values().toArray(listeners);
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].handleDebugEvent(event);
                    ++i;
                }
            }
        } else {
            Object[] listeners = this.fEventListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDebugEventListener)listeners[i]).handleDebugEvent(event);
                ++i;
            }
        }
    }

    public void addDebugEventListener(IDebugEventListener listener) {
        this.fEventListeners.add((Object)listener);
    }

    public void addEvalEventListener(IDebugEventListener listener) {
        this.addEvalEventListener(listener, listener.hashCode());
    }

    public void addEvalEventListener(IDebugEventListener listener, int exprId) {
        this.fEvalEventListenerMap.put(exprId, listener);
    }

    public void removeDebugEventListener(IDebugEventListener listener) {
        this.fEventListeners.remove((Object)listener);
    }

    public void removeEvalEventListener(IDebugEventListener listener) {
        this.fEvalEventListenerMap.remove(listener.hashCode());
    }

    public void connect() throws IOException {
        Thread thread = new Thread((Runnable)this.fEventListener, "Engine Event Listener");
        thread.setDaemon(true);
        thread.start();
        int trials = 4;
        while (true) {
            try {
                this.fRequestConnection.connect();
                this.fReplyReader = new MessageReader(this.fRequestConnection.getInput());
                return;
            }
            catch (IOException iOException) {
                try {
                    if (--trials < 0) {
                        throw new IOException("Failed to connect to the debug engine. Connection failed after 5 connection attempts.");
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    public void terminate() {
        this.sendCommand(61700);
        System.out.println("Terminating engine");
        this.fTerminated = true;
        if (this.fRequestConnection != null) {
            System.out.println("Terminating engine command connection");
            this.fRequestConnection.close();
            System.out.println("connection open: " + this.fRequestConnection.isOpen());
            this.fRequestConnection = null;
        }
        if (this.fEventConnection != null) {
            System.out.println("Terminating engine event listener");
            this.fEventConnection.close();
            System.out.println("connection open: " + this.fEventConnection.isOpen());
            this.fEventConnection = null;
        }
        this.fReplyReader = null;
        this.fEventListeners.clear();
    }

    private AbstractReplyMessage sendCommand(int command) {
        return this.sendCommand(MessageFactory.buildCommand(command));
    }

    public AbstractReplyMessage sendCommand(AbstractCommandMessage message) {
        System.out.println("Sending command: " + message.getClass().getSimpleName());
        AbstractReplyMessage reply = null;
        try {
            System.out.println("Sending to engine:" + new String(message.toByteArray()));
            this.fRequestConnection.writePacket(message.toByteArray());
            System.out.println("Waiting fo reply...");
            reply = (AbstractReplyMessage)this.fReplyReader.readMessage();
            System.out.println("Reply received");
        }
        catch (IOException iOException) {}
        return reply;
    }

    public void run() {
        AbstractReplyMessage reply = this.sendCommand(61697);
        this.handleReply(reply);
    }

    public void suspend() {
        AbstractReplyMessage reply = this.sendCommand(61698);
        this.handleReply(reply);
    }

    public void resume() {
        AbstractReplyMessage reply = this.sendCommand(61699);
        this.handleReply(reply);
    }

    private void handleReply(AbstractReplyMessage reply) {
        if (reply == null) {
            throw new ProtocolException("null reply message");
        }
        if (reply.getErrorCode() == 0) {
            return;
        }
        ReplyMessage errorReply = (ReplyMessage)reply;
        switch (errorReply.getErrorCode()) {
            case 12: {
                int errorCode = -1;
                if (errorReply.getData() != null) {
                    // empty if block
                }
                try {
                    errorCode = Integer.parseInt(new String(errorReply.getData()));
                }
                catch (NumberFormatException numberFormatException) {}
                throw new InvalidCommandException(errorCode);
            }
            case 13: {
                int errorCode = -1;
                if (errorReply.getData() != null) {
                    // empty if block
                }
                try {
                    errorCode = Integer.parseInt(new String(errorReply.getData()));
                }
                catch (NumberFormatException numberFormatException) {}
                throw new CommandNotImplementedException(errorCode);
            }
            case 11: {
                throw new MessageFormatException("The message received by the engine had an invalid format.");
            }
            case 1: {
                throw new ProtocolException();
            }
        }
        try {
            throw new ProtocolException("Unknown error code: " + errorReply.getErrorCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void setSuspended(boolean suspended) {
        this.fSuspended = suspended;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void setTerminated(boolean terminated) {
        this.fTerminated = terminated;
    }

    public void setBreakpoint(IBreakpoint breakpoint) {
        SetMessage message = (SetMessage)MessageFactory.buildCommand(61953);
        AbstractReplyMessage reply = this.sendCommand(message);
        this.handleReply(reply);
    }

    public void setBreakpoints(List<IBreakpoint> breakpoints) {
        if (breakpoints == null || breakpoints.size() == 0) {
            return;
        }
        SetMessage message = (SetMessage)MessageFactory.buildCommand(61953);
        AbstractReplyMessage reply = this.sendCommand(message);
        this.handleReply(reply);
    }

    public void clearBreakpoint(IBreakpoint breakpoint) {
        ClearMessage message = (ClearMessage)MessageFactory.buildCommand(61954);
        message.addBreakpointId(Math.abs(breakpoint.hashCode()));
        AbstractReplyMessage reply = this.sendCommand(message);
        this.handleReply(reply);
    }

    public Variable[] getVariables() {
        VariablesMessage command = new VariablesMessage();
        ReplyMessage reply = (ReplyMessage)this.sendCommand(command);
        VariablesPayload payload = command.getVariables(reply);
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable variable : payload.getGlobalVariables()) {
            variable.setIsGlobal(true);
            vars.add(variable);
        }
        vars.addAll(payload.getLocalVariables());
        return vars.toArray(new Variable[vars.size()]);
    }

    public QueryLocation[] getStackFrames() {
        FramesMessage command = new FramesMessage();
        ReplyMessage reply = (ReplyMessage)this.sendCommand(command);
        return command.readLocations(reply);
    }

    public void step(int stepType) {
        AbstractReplyMessage reply = this.sendCommand(new StepMessage(stepType));
        this.handleReply(reply);
    }

    public void evaluate(String expression, int listenerId) {
        System.out.println("Evaluating: " + expression);
        EvaluateMessage command = new EvaluateMessage(listenerId, expression);
        AbstractReplyMessage reply = this.sendCommand(command);
        this.handleReply(reply);
    }

    public void requestTermination() {
    }

    public void waitTerminated() throws InterruptedException {
    }

    public void addDebugEventListener(Object listener) {
    }

    public void removeDebugEventListener(Object listener) {
    }

    public Object sendCommand(Object command) {
        return null;
    }

    private class EventListener
    implements Runnable {
        private EventListener() {
        }

        public void run() {
            try {
                ZorbaDebuggerEngine.this.fEventConnection.connect();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            ZorbaDebuggerEngine.this.fEventReader = new MessageReader(ZorbaDebuggerEngine.this.fEventConnection.getInput());
            try {
                AbstractCommandMessage event = (AbstractCommandMessage)ZorbaDebuggerEngine.this.fEventReader.readMessage();
                while (!ZorbaDebuggerEngine.this.fTerminated && event != null) {
                    ZorbaDebuggerEngine.this.fReceivedEvents.add(event);
                    ZorbaDebuggerEngine.this.notifyListeners(event);
                    event = null;
                    try {
                        event = (AbstractCommandMessage)ZorbaDebuggerEngine.this.fEventReader.readMessage();
                    }
                    catch (IOException se) {
                        if (ZorbaDebuggerEngine.this.fTerminated) continue;
                        ZorbaDebuggerEngine.this.fTerminated = true;
                        ZorbaDebuggerEngine.this.terminate();
                        ZorbaDebuggerEngine.this.fireObjectTerminated(se);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        private IStatus handleException(Exception exception) {
            exception.printStackTrace();
            return new Status(4, "org.eclipse.wst.xquery.debug.core", 0, exception.getMessage(), (Throwable)exception);
        }
    }
}

