/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.MessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ProtocolException;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.ReplyMessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication.RequestMessageHeader;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.AbstractMessage;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.MessageFactory;
import org.eclipse.wst.xquery.debug.debugger.zorba.translator.messages.MessageFormatException;

public class MessageReader {
    private DataInputStream fInputStream;

    public MessageReader(InputStream inputStream) {
        this.fInputStream = new DataInputStream(inputStream);
    }

    public AbstractMessage readMessage() throws ProtocolException, IOException {
        MessageHeader header = this.readMessageHeader();
        if (header.getMessageLength() == 1481721953 && header.getId() == 1852076904 && header.getFlags() == 97) {
            return MessageFactory.buildHandshake();
        }
        byte[] data = this.readMessageData(header);
        AbstractMessage message = MessageFactory.buildMessage(header, data);
        return message;
    }

    private MessageHeader readMessageHeader() throws ProtocolException, IOException {
        boolean isReply;
        int length = this.fInputStream.readInt();
        if (length < 11) {
            throw new MessageFormatException();
        }
        int id = this.fInputStream.readInt();
        if (id < 0) {
            throw new MessageFormatException();
        }
        int oneByte = this.fInputStream.read() & 0xFF;
        if (oneByte == -1) {
            throw new MessageFormatException();
        }
        int flags = oneByte;
        boolean bl = isReply = (flags & 0x80) != 0;
        if (isReply) {
            int errorCode = this.fInputStream.readShort() & 0xFFFF;
            if (errorCode < 0) {
                throw new MessageFormatException();
            }
            return new ReplyMessageHeader(length, id, flags, errorCode);
        }
        int commandSet = this.fInputStream.readByte() & 0xFF;
        if (commandSet < 0) {
            throw new MessageFormatException();
        }
        int command = this.fInputStream.readByte() & 0xFF;
        if (command < 0) {
            throw new MessageFormatException();
        }
        return new RequestMessageHeader(length, id, flags, commandSet, command);
    }

    private byte[] readMessageData(MessageHeader header) throws ProtocolException, IOException {
        if (header.getMessageLength() == 11) {
            return null;
        }
        byte[] ba = new byte[header.getMessageLength() - 11];
        int bytesRead = this.fInputStream.read(ba);
        if (bytesRead != header.getMessageLength() - 11) {
            throw new MessageFormatException();
        }
        return ba;
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

