/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.translator.communication;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public abstract class SocketConnection {
    protected Socket fSocket;
    protected OutputStream fOutput;
    protected InputStream fInput;

    public InputStream getInput() {
        return this.fInput;
    }

    public OutputStream getOutput() {
        return this.fOutput;
    }

    public abstract void connect() throws IOException;

    public boolean isOpen() {
        return this.fSocket != null && !this.fSocket.isClosed();
    }

    public void close() {
        if (this.fSocket != null) {
            try {
                this.fSocket.close();
                this.fInput.close();
                this.fOutput.close();
            }
            catch (IOException e) {
                System.out.println("++++++++++++++++++++++++++");
                e.printStackTrace();
            }
        }
        this.fSocket = null;
        this.fInput = null;
        this.fOutput = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException {
        DataInputStream stream;
        Object object = this;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException();
            }
            stream = new DataInputStream(this.fInput);
        }
        object = stream;
        synchronized (object) {
            int packetLength = 0;
            try {
                packetLength = stream.readInt();
            }
            catch (IOException iOException) {
                throw new IOException();
            }
            if (packetLength < 11) {
                throw new IOException("Packet under 11 bytes");
            }
            byte[] packet = new byte[packetLength];
            packet[0] = (byte)(packetLength >>> 24 & 0xFF);
            packet[1] = (byte)(packetLength >>> 16 & 0xFF);
            packet[2] = (byte)(packetLength >>> 8 & 0xFF);
            packet[3] = (byte)(packetLength >>> 0 & 0xFF);
            stream.readFully(packet, 4, packetLength - 4);
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(byte[] packet) throws IOException {
        if (!this.isOpen()) {
            throw new IOException();
        }
        if (packet == null) {
            throw new IllegalArgumentException("Packet cannot be null");
        }
        if (packet.length < 11) {
            throw new IllegalArgumentException("Invalid Packet, must be at least 11 bytes. PacketSize: " + packet.length);
        }
        int packetSize = this.getPacketLength(packet);
        if (packetSize != packet.length) {
            throw new IllegalArgumentException("Invalid Packet: The pachet size doe not match the length field." + packetSize);
        }
        Object object = this;
        synchronized (object) {
            if (this.fOutput == null) {
                throw new IOException();
            }
        }
        object = this.fOutput;
        synchronized (object) {
            this.fOutput.write(packet, 0, packetSize);
        }
    }

    private int getPacketLength(byte[] packet) {
        int len = 0;
        if (packet.length >= 4) {
            len = ((packet[0] & 0xFF) << 24) + ((packet[1] & 0xFF) << 16) + ((packet[2] & 0xFF) << 8) + ((packet[3] & 0xFF) << 0);
        }
        return len;
    }
}

