/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.io;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.eclipse.wst.xquery.marklogic.io.ResourcePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketChannelPool<K> {
    private final SocketResourcePool pool;

    public SocketChannelPool() {
        this.pool = new SocketResourcePool();
    }

    public SocketChannelPool(int limit) {
        this.pool = new SocketResourcePool(limit);
    }

    public void setLimit(int limit) {
        this.pool.setLimit(limit);
    }

    public boolean isEmpty(K key) {
        return this.pool.isEmpty(key);
    }

    public void put(K key, SocketChannel channel, long expireTimeMillis) {
        this.pool.put(key, channel, expireTimeMillis);
    }

    public void put(K key, SocketChannel channel) {
        this.pool.put(key, channel);
    }

    public SocketChannel get(K key) {
        SocketChannel channel = (SocketChannel)this.pool.get(key);
        if (channel != null && !channel.isOpen()) {
            throw new IllegalStateException("pooled channel has been closed: " + channel);
        }
        return channel;
    }

    public long size(K key) {
        return this.pool.size(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SocketResourcePool
    extends ResourcePool<K, SocketChannel> {
        public SocketResourcePool(int limit) {
            super(limit);
        }

        public SocketResourcePool() {
        }

        @Override
        protected void itemExpired(ResourcePool.PoolItem<SocketChannel> item) {
            SocketChannel channel = item.getValue();
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
    }
}

