/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc;

import java.math.BigInteger;
import java.util.Locale;
import java.util.TimeZone;

public class RequestOptions {
    public static final int DEFAULT_MAX_AUTO_RETRY = 4;
    public static final int DEFAULT_AUTO_RETRY_DELAY_MILLIS = 100;
    public static final String MAX_RETRY_SYSTEM_PROPERTY = "xcc.request.retries.max";
    public static final String AUTO_RETRY_DELAY_SYSTEM_PROPERTY = "xcc.request.retries.delay";
    private int maxAutoRetry = -1;
    private int autoRetryDelayMillis = -1;
    private int timeoutMillis = -1;
    private int requestTimeLimit = -1;
    private boolean cacheResult = true;
    private boolean defaultCacheResult = true;
    private String requestName;
    private Locale locale = null;
    private TimeZone timeZone = null;
    private BigInteger effectivePointInTime = null;
    private int resultBufferSize = 0;
    private String defaultXQueryVersion = null;

    public boolean getCacheResult() {
        return this.cacheResult;
    }

    public void setCacheResult(boolean cacheResult) {
        this.cacheResult = cacheResult;
        this.defaultCacheResult = false;
    }

    public int getMaxAutoRetry() {
        return this.maxAutoRetry;
    }

    public void setMaxAutoRetry(int maxAutoRetry) {
        this.maxAutoRetry = maxAutoRetry;
    }

    public int getAutoRetryDelayMillis() {
        return this.autoRetryDelayMillis;
    }

    public void setAutoRetryDelayMillis(int autoRetryDelayMillis) {
        this.autoRetryDelayMillis = autoRetryDelayMillis;
    }

    public int getResultBufferSize() {
        return this.resultBufferSize;
    }

    public void setResultBufferSize(int resultBufferSize) {
        this.resultBufferSize = resultBufferSize;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        if (!this.validRequestName(requestName)) {
            throw new IllegalArgumentException("Not a valid request name: " + requestName);
        }
        this.requestName = requestName;
    }

    private boolean validRequestName(String requestName) {
        if (requestName == null) {
            return true;
        }
        String req = requestName.trim();
        if (!Character.isLetter(req.charAt(0))) {
            return false;
        }
        int i = 0;
        while (i < req.length()) {
            if (!Character.isLetterOrDigit(req.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public BigInteger getEffectivePointInTime() {
        return this.effectivePointInTime;
    }

    public void setEffectivePointInTime(BigInteger effectivePointInTime) {
        this.effectivePointInTime = effectivePointInTime;
    }

    public String getDefaultXQueryVersion() {
        return this.defaultXQueryVersion;
    }

    public void setDefaultXQueryVersion(String versionString) {
        this.defaultXQueryVersion = versionString;
    }

    public int getRequestTimeLimit() {
        return this.requestTimeLimit;
    }

    public void setRequestTimeLimit(int requestTimeLimit) {
        this.requestTimeLimit = requestTimeLimit;
    }

    public void applyEffectiveValues(RequestOptions[] others) {
        int i = 0;
        while (i < others.length) {
            RequestOptions other = others[i];
            if (other.maxAutoRetry != -1) {
                this.maxAutoRetry = other.maxAutoRetry;
            }
            if (other.autoRetryDelayMillis != -1) {
                this.autoRetryDelayMillis = other.autoRetryDelayMillis;
            }
            if (other.timeoutMillis != -1) {
                this.timeoutMillis = other.timeoutMillis;
            }
            if (other.requestName != null) {
                this.requestName = other.requestName;
            }
            if (other.locale != null) {
                this.locale = other.locale;
            }
            if (other.timeZone != null) {
                this.timeZone = other.timeZone;
            }
            if (other.effectivePointInTime != null) {
                this.effectivePointInTime = other.effectivePointInTime;
            }
            if (!other.defaultCacheResult) {
                this.cacheResult = other.cacheResult;
            }
            if (other.resultBufferSize != 0) {
                this.resultBufferSize = other.resultBufferSize;
            }
            if (other.defaultXQueryVersion != null) {
                this.defaultXQueryVersion = other.defaultXQueryVersion;
            }
            if (other.requestTimeLimit != -2) {
                this.requestTimeLimit = other.requestTimeLimit;
            }
            ++i;
        }
        if (this.maxAutoRetry == -1) {
            this.maxAutoRetry = this.getDefaultValue(MAX_RETRY_SYSTEM_PROPERTY, 4);
        }
        if (this.autoRetryDelayMillis == -1) {
            this.autoRetryDelayMillis = this.getDefaultValue(AUTO_RETRY_DELAY_SYSTEM_PROPERTY, 100);
        }
        if (this.timeoutMillis == -1) {
            this.timeoutMillis = 0;
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        if (this.resultBufferSize == 0) {
            this.resultBufferSize = 16384;
        }
    }

    private int getDefaultValue(String propName, int defaultValue) {
        Integer value = Integer.getInteger(propName, null);
        return value == null ? defaultValue : value;
    }
}

