/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.MultipartBuffer;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ResultChannelName;
import org.eclipse.wst.xquery.marklogic.xcc.ResultItem;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.StreamingResultException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.AbstractResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.impl.CachedResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.impl.EmptyResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmItem;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.SequenceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingResultSequence
extends AbstractResultSequence {
    private final SessionImpl session;
    private final MultipartBuffer mbuf;
    private final RequestOptions options;
    private final Logger logger;
    private final long startTime;
    private ServerConnection connection;
    private boolean closed = false;
    private int cursor = -1;
    private ResultItem currentItem = null;
    private IteratorAdapter currentIterator = null;

    public StreamingResultSequence(SessionImpl session, ServerConnection connection, MultipartBuffer mbuf, RequestOptions options, Logger logger) {
        this.session = session;
        this.connection = connection;
        this.mbuf = mbuf;
        this.options = options;
        this.logger = logger;
        this.startTime = System.currentTimeMillis();
        session.registerResultSequence(this);
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.invalidateCurrentIterator();
        this.session.deRegisterResultSequence(this);
        long now = System.currentTimeMillis();
        try {
            this.mbuf.close();
        }
        catch (IOException e) {
            String msg = "IOException closing streaming ResultSequence: " + e.getMessage();
            this.logger.log(Level.WARNING, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        this.connection.setTimeoutTime(this.connection.getTimeoutMillis() - (now - this.startTime));
        this.connection.provider().returnConnection(this.connection, this.logger);
        this.connection = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private boolean hasNext(IteratorAdapter it) {
        if (this.closed) {
            return false;
        }
        if (it != this.currentIterator) {
            this.invalidateCurrentIterator();
        }
        try {
            return this.mbuf.hasNext();
        }
        catch (IOException e) {
            String msg = "IOException in streaming ResultSequence hasNext(): " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(null);
    }

    private ResultItem next(IteratorAdapter it) {
        this.assertNotClosed();
        if (it != this.currentIterator) {
            this.invalidateCurrentIterator();
        }
        ++this.cursor;
        try {
            if (this.mbuf.hasNext()) {
                this.currentItem = this.instantiateResultItem(this.mbuf, this.cursor, this.options);
            } else {
                this.currentItem = null;
                this.cursor = -1;
            }
        }
        catch (IOException e) {
            String msg = "IOException instantiating ResultItem " + this.cursor + ": " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        return this.currentItem;
    }

    @Override
    public ResultItem next() {
        return this.next(null);
    }

    @Override
    public ResultItem current() {
        this.assertNotClosed();
        if (this.currentItem == null) {
            throw new IllegalStateException("No current item");
        }
        return this.currentItem;
    }

    @Override
    public ResultItem resultItemAt(int index) {
        this.assertNotClosed();
        if (this.cursor == -1 || index != this.cursor) {
            throw new IllegalArgumentException("Index out of range or not current, index=" + index);
        }
        return this.currentItem;
    }

    @Override
    public void rewind() {
        this.assertNotClosed();
        throw new IllegalStateException("Cannot rewind streaming result sequences");
    }

    @Override
    public ResultSequence toCached() {
        this.assertNotClosed();
        if (this.currentItem != null && !this.currentItem.isFetchable()) {
            this.next();
        }
        try {
            CachedResultSequence rs = new CachedResultSequence(this.mbuf, this.options);
            this.close();
            return rs;
        }
        catch (IOException e) {
            String msg = "IOException while caching streaming ResultSequence: " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(String.valueOf(msg) + e.getMessage(), this, e);
        }
    }

    @Override
    public ResultItem[] toResultItemArray() {
        ArrayList<ResultItem> list = new ArrayList<ResultItem>();
        while (this.hasNext()) {
            ResultItem item = this.next();
            item.cache();
            list.add(item);
        }
        ResultItem[] array = new ResultItem[list.size()];
        list.toArray(array);
        this.close();
        return array;
    }

    @Override
    public ResultSequence getChannel(ResultChannelName channel) {
        this.assertNotClosed();
        if (channel == ResultChannelName.PRIMARY) {
            return this;
        }
        return new EmptyResultSequence(this);
    }

    @Override
    public Iterator<ResultItem> iterator() {
        this.assertNotClosed();
        this.invalidateCurrentIterator();
        this.currentIterator = new IteratorAdapter(this);
        return this.currentIterator;
    }

    @Override
    public XdmItem itemAt(int index) {
        return this.resultItemAt(index).getItem();
    }

    @Override
    public boolean isEmpty() {
        return this.closed;
    }

    @Override
    public XdmItem[] toArray() {
        ResultItem[] resultItems = this.toResultItemArray();
        XdmItem[] array = new XdmItem[resultItems.length];
        int i = 0;
        while (i < resultItems.length) {
            array[i] = resultItems[i].getItem();
            ++i;
        }
        return array;
    }

    @Override
    public String asString(String separator) {
        return this.toCached().asString(separator);
    }

    @Override
    public String asString() {
        return this.asString("\n");
    }

    @Override
    public String[] asStrings() {
        return SequenceImpl.asStringArray(this);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.SEQUENCE;
    }

    @Override
    public String toString() {
        return "StreamingResultSequence: closed=" + this.closed;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResultSequence is closed");
        }
    }

    private void invalidateCurrentIterator() {
        if (this.currentIterator != null) {
            this.currentIterator.invalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorAdapter
    implements Iterator<ResultItem> {
        private StreamingResultSequence parent;
        private volatile boolean invalidated = false;

        public IteratorAdapter(StreamingResultSequence parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            this.assertValid();
            return this.parent.hasNext(this);
        }

        @Override
        public ResultItem next() {
            this.assertValid();
            ResultItem obj = this.parent.next(this);
            if (obj == null) {
                throw new NoSuchElementException("No more items in ResultSequence");
            }
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ResultSequences are not mutable");
        }

        private void invalidate() {
            this.invalidated = true;
        }

        private void assertValid() {
            if (this.invalidated) {
                throw new ConcurrentModificationException("This Iterator has been invalidated");
            }
        }
    }
}

