/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.impl.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.http.HttpChannel;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;
import org.eclipse.wst.xquery.marklogic.xcc.Content;
import org.eclipse.wst.xquery.marklogic.xcc.ContentCreateOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ContentPermission;
import org.eclipse.wst.xquery.marklogic.xcc.DocumentFormat;
import org.eclipse.wst.xquery.marklogic.xcc.DocumentRepairLevel;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.RequestOptions;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.ContentInsertException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestException;
import org.eclipse.wst.xquery.marklogic.xcc.impl.RequestImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.SessionImpl;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.AbstractRequestController;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.EntityResolveHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.GoodInsertResponseHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.NotFoundCodeHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ResponseHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ServerExceptionHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.ServiceUnavailableHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.UnauthorizedHandler;
import org.eclipse.wst.xquery.marklogic.xcc.impl.handlers.UnrecognizedCodeHandler;
import org.eclipse.wst.xquery.marklogic.xcc.spi.ServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentInsertController
extends AbstractRequestController {
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    static final int DEFAULT_BUFFER_SIZE = 131072;
    static final int MAX_BUFFER_SIZE = 0xC00000;
    private static final int DATA_CHUNK = 0;
    private static final int COMMIT = 1;
    private static final int NO_COMMIT = 2;
    private static final Map<Integer, ResponseHandler> handlers = new HashMap<Integer, ResponseHandler>(8);
    private final Content[] contents;
    private final boolean commit;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(16);
    private final LinkedList<Content> processedContent = new LinkedList();
    private ByteBuffer dataBuffer = null;
    private static final int PLATEAU = 2000;
    private static final int PLATEAU_SHORT_CIRCUIT = 20;

    static {
        ContentInsertController.addDefaultHandler(handlers, new UnrecognizedCodeHandler());
        ContentInsertController.addHandler(handlers, 503, new ServiceUnavailableHandler());
        ContentInsertController.addHandler(handlers, 500, new ServerExceptionHandler());
        ContentInsertController.addHandler(handlers, 401, new UnauthorizedHandler());
        ContentInsertController.addHandler(handlers, 404, new NotFoundCodeHandler());
        ContentInsertController.addHandler(handlers, 400, new NotFoundCodeHandler());
        ContentInsertController.addHandler(handlers, 200, new GoodInsertResponseHandler());
        ContentInsertController.addHandler(handlers, 307, new EntityResolveHandler());
    }

    public ContentInsertController(Content[] contents, boolean commit) {
        super(handlers);
        this.contents = (Content[])contents.clone();
        this.commit = commit;
    }

    @Override
    public ResultSequence serverDialog(ServerConnection connection, Request request, RequestOptions options, Logger logger) throws RequestException, IOException {
        this.assertRestartable(this.processedContent, request);
        LinkedList<ContentDecorator> remaining = this.toLinkedList(this.contents);
        logger.fine("beginning content insert dialog, " + remaining.size() + " documents queued");
        HttpChannel http = new HttpChannel(connection.channel(), "PUT", "/", 0, options.getTimeoutMillis(), logger);
        while (remaining.size() > 0) {
            boolean commit;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.processedContent.size() + " items sent, " + remaining.size() + " remaining");
            }
            ContentDecorator content = remaining.remove(0);
            boolean bl = commit = this.commit && remaining.size() == 0;
            if (!content.isEntity()) {
                this.processedContent.add(content);
            }
            if (logger.isLoggable(Level.FINE)) {
                if (content.isEntity()) {
                    logger.fine("processing entity '" + content.getLocation() + "' for document '" + content.getUri() + "'");
                } else {
                    logger.fine("processing '" + content.getUri() + "'");
                }
            }
            this.resetHttpChannel(http, request, options, content, commit);
            this.issueRequest(http, content, commit, logger);
            int code = http.getResponseCode();
            ContentDecorator entityContent = null;
            try {
                try {
                    ResponseHandler handler = this.findHandler(code);
                    entityContent = (ContentDecorator)handler.handleResponse(http, code, request, content, logger);
                }
                catch (ContentInsertException e) {
                    connection.close();
                    throw e;
                }
            }
            finally {
                if (connection.isOpen()) {
                    this.setConnectionTimeout(connection, http);
                }
            }
            if (entityContent == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("queueing entity content for '" + entityContent.getUri() + "', location: " + entityContent.getLocation());
            }
            remaining.addFirst(entityContent);
        }
        this.closeContent(this.processedContent);
        logger.fine("finished content insert dialog, " + this.contents.length + " documents successfully inserted");
        return null;
    }

    @Override
    protected long interTryDelay(long delay, int currentTry) {
        if (currentTry == 0 || delay <= 0L) {
            return 0L;
        }
        if (currentTry >= 20) {
            return 2000L;
        }
        long millis = delay * (long)(1 << currentTry - 1);
        return millis > 2000L ? 2000L : millis;
    }

    private void resetHttpChannel(HttpChannel http, Request request, RequestOptions options, Content content, boolean commit) {
        SessionImpl session = (SessionImpl)request.getSession();
        String pathUri = content.getUri() == null ? null : ContentInsertController.makeReqUri(content, request, commit);
        String method = "PUT";
        http.reset(method, pathUri);
        http.setRequestContentType("text/xml");
        this.addCommonHeaders(http, session, method, pathUri, options);
        http.setRequestHeader("Connection", "keep-alive");
    }

    private void issueRequest(HttpChannel http, ContentDecorator content, boolean commit, Logger logger) throws IOException {
        int rc;
        String uri = content.getUri();
        if (logger.isLoggable(Level.FINE)) {
            if (content.isEntity()) {
                logger.fine("sending entity (location=" + content.getLocation() + ") for uri=" + uri + ", size=" + content.size());
            } else {
                logger.fine("sending content: uri=" + uri + ", size=" + content.size());
            }
        }
        ByteBuffer dataBuffer = this.allocDataBuffer(content);
        byte[] dataBytes = dataBuffer.array();
        InputStream inStream = content.openDataStream();
        boolean checkBOM = this.mayHaveBOM(content);
        if (content.isEntity()) {
            http.suppressHeaders();
        }
        while ((rc = inStream.read(dataBytes)) != -1) {
            dataBuffer.clear();
            dataBuffer.limit(rc);
            if (checkBOM) {
                checkBOM = false;
                if (rc >= 3 && this.hasBOM(dataBytes)) {
                    rc -= 3;
                    dataBuffer.position(3);
                    logger.finest("suppressed UTF-8 BOM");
                }
            }
            this.writeChunkHeader(http, 0, rc, logger);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("writing " + rc + " bytes of data");
            }
            http.write(dataBuffer);
        }
        inStream.close();
        this.writeChunkHeader(http, commit ? 1 : 2, 0, logger);
        logger.fine("finished sending content: commit=" + commit);
    }

    private boolean mayHaveBOM(ContentDecorator content) {
        boolean isUtf8;
        ContentCreateOptions options = content.getCreateOptions();
        String encoding = options == null ? "utf-8" : options.getEncoding();
        DocumentFormat fmt = options == null ? DocumentFormat.NONE : options.getFormat();
        boolean bl = isUtf8 = options == null || "utf-8".equalsIgnoreCase(encoding) || "utf8".equalsIgnoreCase(encoding);
        return isUtf8 && fmt != DocumentFormat.BINARY && fmt != DocumentFormat.NONE;
    }

    private boolean hasBOM(byte[] bytes) {
        return (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191;
    }

    private void assertRestartable(LinkedList<Content> processedContent, Request request) throws ContentInsertException {
        while (processedContent.size() > 0) {
            ContentDecorator content = (ContentDecorator)processedContent.removeFirst();
            if (content.isPristine()) continue;
            if (content.isRewindable()) {
                try {
                    content.rewind();
                    continue;
                }
                catch (IOException e) {
                    processedContent.clear();
                    throw new ContentInsertException("Cannot auto-restart insert, error rewinding content: " + content.getUri(), request, content.getOriginal(), e);
                }
            }
            processedContent.clear();
            throw new ContentInsertException("Cannot auto-restart insert, non-rewindable content already processed: " + content.getUri(), request, content.getOriginal());
        }
    }

    private void closeContent(LinkedList<Content> processedContent) {
        while (processedContent.size() > 0) {
            Content content = processedContent.removeFirst();
            content.close();
        }
    }

    private LinkedList<ContentDecorator> toLinkedList(Content[] array) {
        LinkedList<ContentDecorator> list = new LinkedList<ContentDecorator>();
        int i = 0;
        while (i < array.length) {
            list.add(new ContentDecorator(array[i]));
            ++i;
        }
        return list;
    }

    private void writeChunkHeader(HttpChannel http, int code, int count, Logger logger) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("writing chunk header: " + code + count);
        }
        this.headerBuffer.clear();
        this.headerBuffer.put((byte)(48 + code));
        this.headerBuffer.put(Integer.toString(count).getBytes());
        this.headerBuffer.put((byte)13);
        this.headerBuffer.put((byte)10);
        this.headerBuffer.flip();
        http.write(this.headerBuffer);
    }

    ByteBuffer allocDataBuffer(Content content) {
        ContentCreateOptions options = content.getCreateOptions();
        int userSize = options == null ? -1 : options.getBufferSize();
        int bufSize = (int)(content.size() == -1L ? 131072L : content.size());
        bufSize = userSize == -1 ? bufSize : Math.min(bufSize, userSize);
        bufSize = Math.min(bufSize, 0xC00000);
        if (this.dataBuffer == null || this.dataBuffer.capacity() < bufSize) {
            this.dataBuffer = ByteBuffer.allocate(bufSize);
        }
        return this.dataBuffer;
    }

    static String makeReqUri(Content content, Request request, boolean commit) {
        int i;
        ContentCreateOptions options = content.getCreateOptions() == null ? new ContentCreateOptions() : content.getCreateOptions();
        RequestOptions requestOptions = request == null ? new RequestOptions() : request.getEffectiveOptions();
        StringBuffer sb = new StringBuffer(256);
        sb.append("/insert?uri=");
        IOHelper.urlEncodeToStringBuffer(sb, content.getUri());
        if (!commit) {
            sb.append("&nocommit");
        }
        if (options.getLocale() != null) {
            if (request == null) {
                sb.append("&locale=").append(options.getLocale().toString());
            } else {
                requestOptions.setLocale(options.getLocale());
            }
        }
        if (options.getLanguage() != null) {
            sb.append("&lang=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getLanguage());
        }
        if (options.getNamespace() != null) {
            sb.append("&defaultns=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getNamespace());
        }
        if (options.getQuality() != 0) {
            sb.append("&quality=").append(options.getQuality());
        }
        if (options.getResolveEntities()) {
            sb.append("&resolve");
        }
        if (options.getResolveBufferSize() != 0) {
            sb.append("&resolvesiz=").append(options.getResolveBufferSize());
        }
        if (options.getRepairLevel() == DocumentRepairLevel.NONE) {
            sb.append("&repair=none");
        }
        if (options.getRepairLevel() == DocumentRepairLevel.FULL) {
            sb.append("&repair=full");
        }
        if (!"UTF-8".equalsIgnoreCase(options.getEncoding())) {
            sb.append("&encoding=").append(options.getEncoding());
        }
        if (options.getFormat() == DocumentFormat.XML) {
            sb.append("&format=xml");
        }
        if (options.getFormat() == DocumentFormat.TEXT) {
            sb.append("&format=text");
        }
        if (options.getFormat() == DocumentFormat.BINARY) {
            sb.append("&format=binary");
        }
        if (options.getPlaceKeys() != null) {
            BigInteger[] keys = options.getPlaceKeys();
            i = 0;
            while (i < keys.length) {
                sb.append("&placeKey=").append(keys[i].toString());
                ++i;
            }
        }
        if (options.getCollections() != null) {
            String[] collections = options.getCollections();
            if (collections.length == 0) {
                sb.append("&nocolls");
            } else {
                i = 0;
                while (i < collections.length) {
                    sb.append("&coll=");
                    IOHelper.urlEncodeToStringBuffer(sb, collections[i]);
                    ++i;
                }
            }
        }
        if (options.getPermissions() != null) {
            ContentPermission[] perms = options.getPermissions();
            if (perms.length == 0) {
                sb.append("&noperms");
            } else {
                i = 0;
                while (i < perms.length) {
                    ContentPermission perm = perms[i];
                    String symbol = perm.getCapability() == null ? "N" : perm.getCapability().getSymbol();
                    sb.append("&perm=").append(symbol);
                    IOHelper.urlEncodeToStringBuffer(sb, perm.getRole());
                    ++i;
                }
            }
        }
        if (request != null) {
            ((RequestImpl)request).encodeQueryOptions(sb, requestOptions);
        }
        return sb.substring(0);
    }

    static class ContentDecorator
    implements Content {
        private final Content content;
        private final Content parent;
        private final String location;
        private boolean pristine = true;

        public ContentDecorator(Content content) {
            this.content = content;
            this.parent = null;
            this.location = null;
        }

        public ContentDecorator(Content entity, Content parent, String location) {
            this.content = entity;
            this.parent = parent;
            this.location = location;
        }

        public String getUri() {
            return this.parent == null ? this.content.getUri() : this.parent.getUri();
        }

        public InputStream openDataStream() throws IOException {
            this.pristine = false;
            return this.content.openDataStream();
        }

        public ContentCreateOptions getCreateOptions() {
            return this.content.getCreateOptions();
        }

        public boolean isRewindable() {
            return this.content.isRewindable();
        }

        public void rewind() throws IOException {
            this.pristine = false;
            this.content.rewind();
        }

        public long size() {
            return this.content.size();
        }

        public void close() {
            this.pristine = false;
            this.content.close();
        }

        public boolean isEntity() {
            return this.location != null;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isPristine() {
            return this.pristine;
        }

        public Content getOriginal() {
            return this.content;
        }
    }
}

