/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.jndi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSource;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSourceFactory;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.XccConfigException;

public class ContentSourceBean
implements ContentSource {
    private ContentSource cs = null;
    private String host = null;
    private int port = 0;
    private String user = null;
    private String password = null;
    private String contentBase = null;
    private URI url = null;

    public Session newSession() {
        return this.getContentSource().newSession();
    }

    public Session newSession(String databaseId) {
        return this.getContentSource().newSession(databaseId);
    }

    public Session newSession(String userName, String password) {
        return this.getContentSource().newSession(userName, password);
    }

    public Session newSession(String userName, String password, String databaseId) {
        return this.getContentSource().newSession(userName, password, databaseId);
    }

    public Logger getDefaultLogger() {
        return this.getContentSource().getDefaultLogger();
    }

    public void setDefaultLogger(Logger logger) {
        this.getContentSource().setDefaultLogger(logger);
    }

    public String toString() {
        return this.getContentSource().toString();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setContentBase(String contentBase) {
        this.contentBase = contentBase;
    }

    public void setUrl(String url) throws URISyntaxException {
        this.url = new URI(url);
    }

    private ContentSource getContentSource() {
        if (this.cs != null) {
            return this.cs;
        }
        if (this.url == null) {
            this.cs = ContentSourceFactory.newContentSource(this.host, this.port, this.user, this.password, this.contentBase);
        } else {
            try {
                this.cs = ContentSourceFactory.newContentSource(this.url);
            }
            catch (XccConfigException e) {
                throw new IllegalArgumentException("Cannot create ContentSource from URI: " + e);
            }
        }
        return this.cs;
    }
}

