/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.jndi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.eclipse.wst.xquery.marklogic.xcc.ContentSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentSourceBeanFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> addrs = ref.getAll();
        String host = null;
        int port = 0;
        String user = null;
        String password = null;
        String contentBase = null;
        URI url = null;
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            String attrName = addr.getType();
            String attrValue = (String)addr.getContent();
            if (attrName.equals("host")) {
                host = attrValue;
            }
            if (attrName.equals("user")) {
                user = attrValue;
            }
            if (attrName.equals("password")) {
                password = attrValue;
            }
            if (attrName.equals("contentBase")) {
                contentBase = attrValue;
            }
            if (attrName.equals("contentbase")) {
                contentBase = attrValue;
            }
            if (attrName.equals("url")) {
                try {
                    url = new URI(attrValue);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new NamingException("Bad URL: " + attrValue);
                }
            }
            if (!attrName.equals("port")) continue;
            try {
                port = Integer.parseInt(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NamingException("Invalid port value " + attrValue);
            }
        }
        if (url == null && (host == null || port == 0)) {
            throw new NamingException("At least URL or host and port attributes must be specified");
        }
        if (url != null) {
            return ContentSourceFactory.newContentSource(url);
        }
        return ContentSourceFactory.newContentSource(host, port, user, password, contentBase);
    }
}

