/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.xquery.marklogic.xcc.types.ValueType;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmItem;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmSequence;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceImpl
implements XdmSequence<XdmItem> {
    private List<XdmItem> items = new ArrayList<XdmItem>();

    public SequenceImpl(XdmValue[] values) {
        this.flattenValues(this.items, values);
    }

    private void flattenValues(List<XdmItem> items, XdmValue[] values) {
        int i = 0;
        while (i < values.length) {
            XdmValue value = values[i];
            if (value instanceof XdmSequence) {
                XdmSequence seq = (XdmSequence)value;
                this.flattenValues(items, seq.toArray());
            } else {
                items.add((XdmItem)value);
            }
            ++i;
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public XdmItem[] toArray() {
        XdmItem[] array = new XdmItem[this.items.size()];
        this.items.toArray(array);
        return array;
    }

    @Override
    public XdmItem itemAt(int index) {
        return this.items.get(index);
    }

    @Override
    public Iterator<XdmItem> iterator() {
        return Collections.unmodifiableList(this.items).iterator();
    }

    @Override
    public String asString(String separator) {
        return SequenceImpl.asStringConcatenation(this, separator);
    }

    @Override
    public String asString() {
        return this.asString("\n");
    }

    @Override
    public String[] asStrings() {
        return SequenceImpl.asStringArray(this);
    }

    public static String asStringConcatenation(XdmSequence<?> sequence, String separator) {
        StringBuffer sb = new StringBuffer(512);
        String[] strings = sequence.asStrings();
        int i = 0;
        while (i < strings.length) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(strings[i]);
            ++i;
        }
        return sb.substring(0);
    }

    public static String[] asStringArray(XdmSequence<?> sequence) {
        XdmItem[] items = sequence.toArray();
        String[] strings = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strings[i] = items[i].asString();
            ++i;
        }
        return strings;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.SEQUENCE;
    }

    @Override
    public String toString() {
        return "XdmSequence: size=" + this.size();
    }
}

