/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.debug.core.model;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

public class SETDebugTarget
implements IDebugTarget {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private IProject fProject;
    private String fName;

    public SETDebugTarget(ILaunch launch, IProcess process, IProject project) {
        this.fProcess = process;
        this.fLaunch = launch;
        this.fProject = project;
        this.init(launch, project);
    }

    private void init(ILaunch launch, IProject project) {
        ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
        try {
            String host = config.getAttribute("xqdt_set_host", "localhost");
            int port = config.getAttribute("xqdt_set_port", 8080);
            this.fName = "Project \"" + this.fProject.getName() + "\" running at http://" + host + ":" + port;
        }
        catch (CoreException coreException) {
            this.fName = "Project \"" + this.fProject.getName() + "\" (unknown host and port)";
        }
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return new IThread[0];
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public String getModelIdentifier() {
        return "id";
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fProcess.isTerminated();
    }

    public void terminate() throws DebugException {
        this.fProcess.terminate();
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }
}

