/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.debug.ui;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.ui.interpreters.InterpretersUpdater;
import org.eclipse.dltk.internal.launching.LazyFileHandle;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xquery.set.internal.debug.ui.launcher.ServerJobTools;
import org.eclipse.wst.xquery.set.internal.launching.CoreSDKInstallType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class SETDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.xquery.set.debug.ui";
    private static SETDebugUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ServerJobTools.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SETDebugUIPlugin getDefault() {
        return plugin;
    }

    private void searchAndAddDefaultCoreSdk() {
        try {
            if (Platform.getOS().equals("win32")) {
                ScriptRuntime.DefaultInterpreterEntry entry = new ScriptRuntime.DefaultInterpreterEntry("org.eclipse.wst.xquery.set.core.nature", EnvironmentManager.getLocalEnvironment().getId());
                ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)entry);
                Bundle[] bundles = Platform.getBundles((String)"org.eclipse.wst.xquery.set.coresdk.win32", null);
                if (bundles == null || bundles.length == 0) {
                    return;
                }
                Bundle bundle = bundles[0];
                URL coreSdkURL = bundle.getEntry("/coresdk/bin/sausalito.bat");
                String id = String.valueOf(System.currentTimeMillis());
                LazyFileHandle installLocation = new LazyFileHandle(EnvironmentManager.getLocalEnvironment().getId(), (IPath)new Path(FileLocator.toFileURL((URL)coreSdkURL).getFile()));
                InterpreterStandin coreSdk = new InterpreterStandin((IInterpreterInstallType)new CoreSDKInstallType(), id);
                coreSdk.setInstallLocation((IFileHandle)installLocation);
                coreSdk.setName("Sausalito CoreSDK");
                coreSdk.setInterpreterArgs(null);
                LibraryLocation lib = new LibraryLocation(installLocation.getFullPath().removeLastSegments(2).append("modules"));
                coreSdk.setLibraryLocations(new LibraryLocation[]{lib});
                boolean[] canceled = new boolean[1];
                InterpretersUpdater updater = new InterpretersUpdater();
                if (!updater.updateInterpreterSettings("org.eclipse.wst.xquery.set.core.nature", new IInterpreterInstall[]{coreSdk}, new IInterpreterInstall[]{coreSdk})) {
                    canceled[0] = true;
                }
                if (canceled[0]) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Could update the interpreter settings"));
                } else {
                    IEclipsePreferences node = new InstanceScope().getNode(PLUGIN_ID);
                    node.flush();
                }
            } else if (!Platform.getOS().equals("linux")) {
                Platform.getOS().equals("macosx");
            }
        }
        catch (BackingStoreException backingStoreException) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Could not mark the enablement of the default CoreSDK in the plugin preferences"));
        }
        catch (IOException iOException) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Could not find the default CoreSDK Sausalito script"));
        }
    }
}

