/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.debug.ui.launchConfigurations;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class SocketSelectionBlock {
    public Combo fIpCombo;
    public Spinner fPortSpinner;

    public SocketSelectionBlock(Composite parent) {
        this.createIPAdressSection(parent);
    }

    protected void createIPAdressSection(Composite parent) {
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText("Application server endpoint");
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainGroup.setLayout((Layout)layout);
        Composite comp = new Composite((Composite)mainGroup, 0);
        GridLayout topLayout = new GridLayout(2, false);
        comp.setLayout((Layout)topLayout);
        this.addIPCombo(comp);
        this.addPortSpinner(comp);
    }

    private void addIPCombo(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText("IP Address:");
        this.fIpCombo = SWTFactory.createCombo((Composite)comp, (int)8, (int)1, (String[])this.getIPAddresses());
    }

    private void addPortSpinner(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText("Port:");
        this.fPortSpinner = new Spinner(comp, 133120);
        this.fPortSpinner.setLayoutData((Object)new GridData(768));
        this.fPortSpinner.setMinimum(0);
        this.fPortSpinner.setMaximum(65535);
        this.fPortSpinner.setIncrement(1);
        this.fPortSpinner.setPageIncrement(100);
    }

    private String[] getIPAddresses() {
        ArrayList<String> ipstr = new ArrayList<String>();
        String localhost = "127.0.0.1";
        ipstr.add(localhost);
        try {
            InetAddress[] ips = Inet4Address.getAllByName(Inet4Address.getLocalHost().getHostName());
            int i = 0;
            while (i < ips.length) {
                if (ips[i] instanceof Inet4Address && !ips[i].getHostAddress().equals(localhost)) {
                    ipstr.add(ips[i].getHostAddress());
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return ipstr.toArray(new String[ipstr.size()]);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fIpCombo.addSelectionListener(listener);
        this.fPortSpinner.addSelectionListener(listener);
    }
}

