/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.wst.xquery.set.internal.launching.CoreSDKInstall;
import org.eclipse.wst.xquery.set.launching.SETLaunchingPlugin;

public class CoreSDKInstallType
implements IInterpreterInstallType,
IExecutableExtension {
    private static final String INSTALL_TYPE_NAME = "Sausalito CoreSDK";
    private static final String INTERPRETER_NAME = "sausalito";
    private List<IInterpreterInstall> fInterpreters = new ArrayList<IInterpreterInstall>();
    private String fId;

    protected IPath createPathFile(IDeployment deployment) throws IOException {
        return null;
    }

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new CoreSDKInstall(this, id);
    }

    protected ILog getLog() {
        return SETLaunchingPlugin.getDefault().getLog();
    }

    protected String getPluginId() {
        return "org.eclipse.wst.xquery.set.launching";
    }

    public String getName() {
        return INSTALL_TYPE_NAME;
    }

    public String getNatureId() {
        return "org.eclipse.wst.xquery.set.core.nature";
    }

    public IInterpreterInstall createInterpreterInstall(String id) {
        if (this.findInterpreterInstall(id) != null) {
            String format = "Duplicate Sausalito CoreSDK: {0}";
            throw new IllegalArgumentException(MessageFormat.format(format, id));
        }
        IInterpreterInstall install = this.doCreateInterpreterInstall(id);
        this.fInterpreters.add(install);
        return install;
    }

    public void disposeInterpreterInstall(String id) {
        Iterator<IInterpreterInstall> it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = it.next();
            if (!install.getId().equals(id)) continue;
            it.remove();
            ScriptRuntime.fireInterpreterRemoved((IInterpreterInstall)install);
            return;
        }
    }

    public IInterpreterInstall findInterpreterInstall(String id) {
        for (IInterpreterInstall install : this.fInterpreters) {
            if (!install.getId().equals(id)) continue;
            return install;
        }
        return null;
    }

    public IInterpreterInstall findInterpreterInstallByName(String name) {
        for (IInterpreterInstall install : this.fInterpreters) {
            if (!install.getName().equals(name)) continue;
            return install;
        }
        return null;
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation) {
        return this.getDefaultLibraryLocations(installLocation, null);
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables) {
        return this.getDefaultLibraryLocations(installLocation, variables, null);
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables, IProgressMonitor monitor) {
        IPath modulesPath = installLocation.getFullPath().removeLastSegments(2);
        return new LibraryLocation[]{new LibraryLocation(modulesPath.append("modules"))};
    }

    public String getId() {
        return this.fId;
    }

    public IInterpreterInstall[] getInterpreterInstalls() {
        return this.fInterpreters.toArray(new IInterpreterInstall[this.fInterpreters.size()]);
    }

    public IStatus validateInstallLocation(IFileHandle installLocation) {
        if (!installLocation.exists()) {
            return this.createStatus(4, "Invalid Sausalito script location", null);
        }
        if (installLocation.isFile()) {
            return this.validatePossiblyName(installLocation);
        }
        IFileHandle handle = installLocation.getChild("bin").getChild(INTERPRETER_NAME + (Platform.getOS().equals("win32") ? ".bat" : ""));
        IStatus status = this.validatePossiblyName(handle);
        if (status.getSeverity() == 0) {
            installLocation = handle;
        }
        return status;
    }

    public IStatus validatePossiblyName(IFileHandle installLocation) {
        String name = installLocation.getName();
        Path nPath = new Path(name);
        IExecutionEnvironment execEnv = (IExecutionEnvironment)installLocation.getEnvironment().getAdapter(IExecutionEnvironment.class);
        if (execEnv != null && execEnv.isValidExecutableAndEquals(INTERPRETER_NAME.toLowerCase(), (IPath)nPath)) {
            return this.createStatus(0, "", null);
        }
        return this.createStatus(4, "Sausalito script was not found", null);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fId = config.getAttribute("id");
    }

    protected IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getPluginId(), 0, message, throwable);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoreSDKInstallType other = (CoreSDKInstallType)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }
}

