/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.wst.xquery.set.internal.launching.server.Server;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerLaunchJob;
import org.eclipse.wst.xquery.set.internal.launching.server.ServerManager;

public class SETLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = SETLaunchConfigurationDelegate.getLaunchProject(launch);
        if (project == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            return;
        }
        ServerLaunchJob serverJob = ServerManager.getInstance().createServerJob(launch);
        serverJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    SETLaunchConfigurationDelegate.this.openBrowser(launch);
                }
            }
        });
        serverJob.schedule();
    }

    public static IProject getLaunchProject(ILaunch launch) throws CoreException {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String projectName = config.getAttribute("project", "");
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private boolean openExternal() {
        return 1 == WebBrowserPreference.getBrowserChoice();
    }

    private void openBrowser(ILaunch launch) {
        final String[] startPage = new String[1];
        IProject project = null;
        try {
            startPage[0] = launch.getLaunchConfiguration().getAttribute("mainScript", "");
            project = SETLaunchConfigurationDelegate.getLaunchProject(launch);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            return;
        }
        final Server server = ServerManager.getInstance().getProjectServer(project);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    String urlStr = "http://" + server.getHost();
                    if (server.getPort() != 80) {
                        urlStr = String.valueOf(urlStr) + ":" + server.getPort();
                    }
                    if (startPage[0] != null) {
                        urlStr = String.valueOf(urlStr) + startPage[0];
                    }
                    URL url = new URL(urlStr);
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = null;
                    if (SETLaunchConfigurationDelegate.this.openExternal()) {
                        browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    } else {
                        int browserStyle = 14;
                        String browserTitle = "Sausalito: " + url.toString();
                        browser = browserSupport.createBrowser(browserStyle, "SausalitoBrowser", browserTitle.toString(), browserTitle.toString());
                    }
                    browser.openURL(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

