/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.set.internal.ui.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.xquery.set.launching.CoreSdkUtil;
import org.eclipse.wst.xquery.set.ui.SETUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreSDKTemplateUtility {
    private static final String[] EMPTY_STRING_LIST = new String[0];

    public static String[] getTemplateProjectNames() throws CoreException {
        ArrayList<String> templateList = new ArrayList<String>(4);
        IPath templatePath = CoreSDKTemplateUtility.getDefaultCoreSDKTemplatePath();
        if (templatePath == null) {
            return EMPTY_STRING_LIST;
        }
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        final String defaultTemplate = store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects.default");
        File templateDirectory = new File(templatePath.toOSString());
        if (!templateDirectory.exists()) {
            return EMPTY_STRING_LIST;
        }
        File[] members = templateDirectory.listFiles(new FileFilter(){

            public boolean accept(File dir) {
                String dirName = dir.getName();
                return dir.isDirectory() && !dirName.equals(defaultTemplate) && !dirName.equals(".svn");
            }
        });
        templateList = new ArrayList();
        File[] fileArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            templateList.add(file.getName());
            ++n2;
        }
        return templateList.toArray(new String[templateList.size()]);
    }

    public static String[] getTemplateProjectNames(IInterpreterInstall interpreter) throws CoreException {
        ArrayList<String> templateList = new ArrayList<String>(4);
        IPath templatePath = CoreSDKTemplateUtility.getCoreSDKTemplatePath(interpreter);
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        final String defaultTemplate = store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects.default");
        File templateDirectory = new File(templatePath.toOSString());
        if (!templateDirectory.exists()) {
            return EMPTY_STRING_LIST;
        }
        File[] members = templateDirectory.listFiles(new FileFilter(){

            public boolean accept(File dir) {
                String dirName = dir.getName();
                return dir.isDirectory() && !dirName.equals(defaultTemplate) && !dirName.equals(".svn");
            }
        });
        templateList = new ArrayList();
        File[] fileArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            templateList.add(file.getName());
            ++n2;
        }
        return templateList.toArray(new String[templateList.size()]);
    }

    public static void createProjectContent(IProject currProject, String templateName, String projectUriString) throws CoreException {
        URI projectURI = null;
        try {
            projectURI = new URI(projectUriString);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ProjectContentCreator creator = new ProjectContentCreator(currProject, projectURI);
        creator.createContentFromTemplate(templateName, null);
    }

    public static void createProjectContent(IProject currProject, IPath path, IProgressMonitor monitor) throws CoreException {
        ProjectContentCreator creator = new ProjectContentCreator(currProject);
        creator.createContentFromPath(path, monitor);
    }

    private static void copyFile(String fileName, InputStream input, IContainer dst, IProgressMonitor monitor) throws CoreException {
        IFile dstFile = dst.getFile((IPath)new Path(fileName));
        try {
            if (dstFile.exists()) {
                dstFile.setContents(input, true, true, monitor);
            } else {
                dstFile.create(input, true, monitor);
            }
            input.close();
        }
        catch (IOException iOException) {}
    }

    private static Map<String, ZipEntry> getChildEntriesFromZip(IPath path, ZipFile zipFile) {
        int pathLength = path.segmentCount();
        HashMap<String, ZipEntry> childZipEntries = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            Path entryPath = new Path(zipEntry.getName());
            if (entryPath.segmentCount() <= pathLength || !path.isPrefixOf((IPath)entryPath)) continue;
            if (entryPath.segmentCount() == pathLength + 1) {
                childZipEntries.put(zipEntry.getName(), zipEntry);
                continue;
            }
            String name = entryPath.uptoSegment(pathLength + 1).addTrailingSeparator().toString();
            if (childZipEntries.containsKey(name)) continue;
            ZipEntry dirEntry = new ZipEntry(name);
            childZipEntries.put(name, dirEntry);
        }
        return childZipEntries;
    }

    private static IPath getProjectCoreSDKTemplatePath(IProject project) throws CoreException {
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        IPath coresdkPath = CoreSdkUtil.getProjectCoreSDKInstallationPath((IProject)project);
        IPath templatePath = coresdkPath.append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.root")).append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects"));
        return templatePath;
    }

    private static IPath getDefaultCoreSDKTemplatePath() throws CoreException {
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        IPath coresdkPath = CoreSdkUtil.getDefaultCoreSDKInstallationPath();
        if (coresdkPath == null) {
            return null;
        }
        IPath templatePath = coresdkPath.append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.root")).append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects"));
        return templatePath;
    }

    private static IPath getCoreSDKTemplatePath(IInterpreterInstall interpreter) throws CoreException {
        IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();
        IPath coresdkPath = interpreter.getInstallLocation().getPath().removeLastSegments(2);
        IPath templatePath = coresdkPath.append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.root")).append(store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects"));
        return templatePath;
    }

    private static long getFileSize(File folder) {
        if (folder.isFile()) {
            return folder.length();
        }
        long foldersize = 0L;
        File[] filelist = folder.listFiles();
        int i = 0;
        while (i < filelist.length) {
            foldersize += CoreSDKTemplateUtility.getFileSize(filelist[i]);
            ++i;
        }
        return foldersize;
    }

    private static final class ProjectContentCreator {
        private IProject fProject;
        private Map<String, String> fProperties;
        private static IPreferenceStore store = SETUIPlugin.getDefault().getPreferenceStore();

        public ProjectContentCreator(IProject project) {
            this(project, null);
        }

        public ProjectContentCreator(IProject project, URI projectUri) {
            this.fProject = project;
            this.fProperties = new HashMap<String, String>();
            if (projectUri != null) {
                this.fProperties.put("PROJECT_URI", projectUri.toString());
                this.fProperties.put("DEFAULT_NAMESPACE", projectUri.resolve("default").toString());
                this.fProperties.put("ERROR_NAMESPACE", projectUri.resolve("lib/error").toString());
            }
        }

        private void createContentFromTemplate(String templateName, IProgressMonitor monitor) throws CoreException {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            monitor.beginTask("Creating project content from template", -1);
            try {
                IPath templatePath = CoreSDKTemplateUtility.getProjectCoreSDKTemplatePath(this.fProject).append(templateName);
                this.copyDirectoryStructure(templatePath, monitor);
                if (templateName.equals(store.getString("org.eclipse.wst.xquery.set.preferences.templates.projects.default"))) {
                    this.configureFiles();
                }
            }
            finally {
                monitor.done();
            }
        }

        private void createContentFromPath(IPath importLocation, IProgressMonitor monitor) throws CoreException {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            this.copyDirectoryStructure(importLocation, monitor);
        }

        private void copyDirectoryStructure(IPath dirPath, IProgressMonitor monitor) throws CoreException {
            File directory = dirPath.toFile();
            if (!directory.exists()) {
                return;
            }
            int ticks = (int)CoreSDKTemplateUtility.getFileSize(directory) / 1000;
            monitor.beginTask("", ticks);
            SubProgressMonitor sm = new SubProgressMonitor(monitor, ticks);
            sm.beginTask("", ticks);
            try {
                this.generateFiles(directory, (IContainer)this.fProject, (IProgressMonitor)sm);
            }
            finally {
                sm.done();
                monitor.done();
            }
        }

        private void configureFiles() throws CoreException {
            String templateRoot = store.getString("org.eclipse.wst.xquery.set.preferences.templates.root");
            String moduleDir = store.getString("org.eclipse.wst.xquery.set.preferences.templates.modules");
            String configDir = store.getString("org.eclipse.wst.xquery.set.preferences.templates.config");
            String configFilePath = String.valueOf(templateRoot) + "/" + configDir + "/" + store.getString("org.eclipse.wst.xquery.set.preferences.templates.config.sausalito");
            String defaultModulePath = String.valueOf(templateRoot) + "/" + moduleDir + "/" + store.getString("org.eclipse.wst.xquery.set.preferences.templates.modules.default.handler");
            String errorLibPath = String.valueOf(templateRoot) + "/" + moduleDir + "/" + store.getString("org.eclipse.wst.xquery.set.preferences.templates.modules.default.error");
            String[] srcFiles = new String[]{configFilePath, defaultModulePath, errorLibPath};
            String[] dstFiles = new String[]{"/.config/sausalito.xml", "/handlers/default.xq", "/lib/error.xq"};
            IPath installPath = CoreSdkUtil.getProjectCoreSDKInstallationPath((IProject)this.fProject);
            int i = 0;
            while (i < srcFiles.length) {
                IPath modulePath = installPath.append(srcFiles[i]);
                File moduleFile = modulePath.toFile();
                if (!moduleFile.exists()) {
                    return;
                }
                InputStream in = null;
                try {
                    in = this.getProcessedStream(new FileInputStream(moduleFile));
                    CoreSDKTemplateUtility.copyFile(dstFiles[i], in, (IContainer)this.fProject, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        private void generateFiles(File src, IContainer dst, IProgressMonitor monitor) throws CoreException {
            File[] members = src.listFiles();
            int i = 0;
            while (i < members.length) {
                block20: {
                    File member = members[i];
                    if (member.isDirectory()) {
                        String folderName = member.getName();
                        if (!folderName.equals(".svn")) {
                            member.length();
                            IFolder dstContainer = dst.getFolder((IPath)new Path(folderName));
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            monitor.setTaskName("Copying directory: " + member.getPath());
                            if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                                dstContainer.create(true, true, null);
                            }
                            this.generateFiles(member, (IContainer)dstContainer, monitor);
                        }
                    } else {
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(member);
                                int workTicks = (int)member.length() / 1000;
                                CoreSDKTemplateUtility.copyFile(member.getName(), in, dst, null);
                                monitor.worked(workTicks);
                            }
                            catch (IOException iOException) {
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                ++i;
            }
        }

        private static void generateFiles(ZipFile zipFile, IPath path, IContainer dst, IProgressMonitor monitor) throws CoreException {
            int pathLength = path.segmentCount();
            HashMap<String, ZipEntry> childZipEntries = new HashMap<String, ZipEntry>();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                Path entryPath = new Path(zipEntry.getName());
                if (entryPath.segmentCount() <= pathLength || !path.isPrefixOf((IPath)entryPath)) continue;
                if (entryPath.segmentCount() == pathLength + 1) {
                    childZipEntries.put(zipEntry.getName(), zipEntry);
                    continue;
                }
                String name = entryPath.uptoSegment(pathLength + 1).addTrailingSeparator().toString();
                if (childZipEntries.containsKey(name)) continue;
                ZipEntry dirEntry = new ZipEntry(name);
                childZipEntries.put(name, dirEntry);
            }
            for (ZipEntry zipEnry : childZipEntries.values()) {
                String name = new Path(zipEnry.getName()).lastSegment().toString();
                if (zipEnry.isDirectory()) {
                    IFolder dstContainer = null;
                    if (dstContainer == null) {
                        dstContainer = dst.getFolder((IPath)new Path(name));
                    }
                    if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                        dstContainer.create(true, true, monitor);
                    }
                    ProjectContentCreator.generateFiles(zipFile, path.append(name), (IContainer)dstContainer, monitor);
                    continue;
                }
                InputStream in = null;
                try {
                    try {
                        in = zipFile.getInputStream(zipEnry);
                        CoreSDKTemplateUtility.copyFile(name, in, dst, monitor);
                    }
                    catch (IOException iOException) {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * Unable to fully structure code
         */
        private InputStream getProcessedStream(InputStream input) throws IOException, CoreException {
            sb = new StringBuffer();
            endl = "\n";
            if (Platform.getOS().equals("win32")) {
                endl = "\r\n";
            }
            reader = new BufferedReader(new InputStreamReader(input));
            line = reader.readLine();
            ** GOTO lbl17
            {
                start = line.indexOf("${");
                var = line.substring(start + 2, line.indexOf("}$", start + 2));
                repl = this.fProperties.get(var);
                line = line.replace("${" + var + "}$", repl == null ? "" : repl);
                do {
                    if (line.matches(".*\\$\\{.+\\}\\$.*")) continue block0;
                    sb.append(String.valueOf(line) + endl);
                    line = reader.readLine();
lbl17:
                    // 2 sources

                } while (line != null);
            }
            return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        }
    }
}

