/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DecisionProbe;
import org.antlr.analysis.Label;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.BitSet;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarDanglingStateMessage;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.GrammarSemanticsMessage;
import org.antlr.tool.LeftRecursionCyclesMessage;
import org.antlr.tool.Message;
import org.antlr.tool.NonRegularDecisionMessage;
import org.antlr.tool.RecursionOverflowMessage;
import org.antlr.tool.Rule;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDFAConversion
extends BaseTest {
    public void testA() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A C | B;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAB_or_AC() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A B | A C;");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAB_or_AC_k2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\noptions {k=2;}\na : A B | A C;");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAB_or_AC_k1() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\noptions {k=1;}\na : A B | A C;");
        String string = ".s0-A->:s1=>1\n";
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{1, 2};
        String string2 = "A";
        int[] nArray3 = new int[]{2};
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testselfRecurseNonDet() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : A a X | A a Y;");
        List<Object> list = Arrays.asList(new Integer(1), new Integer(2));
        this.assertNonLLStar(grammar, list);
    }

    public void testRecursionOverflow() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a Y | A A A A A X ;\na : A a | Q;");
        List<Object> list = Arrays.asList("a");
        int n = 1;
        this.assertRecursionOverflow(grammar, list, n);
    }

    public void testRecursionOverflow2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a Y | A+ X ;\na : A a | Q;");
        List<Object> list = Arrays.asList("a");
        int n = 1;
        this.assertRecursionOverflow(grammar, list, n);
    }

    public void testRecursionOverflowWithPredOk() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : (a Y)=> a Y | A A A A A X ;\na : A a | Q;");
        String string = ".s0-A->.s1\n.s0-Q&&{synpred1_t}?->:s11=>1\n.s1-A->.s2\n.s1-Q&&{synpred1_t}?->:s10=>1\n.s2-A->.s3\n.s2-Q&&{synpred1_t}?->:s9=>1\n.s3-A->.s4\n.s3-Q&&{synpred1_t}?->:s8=>1\n.s4-A->.s5\n.s4-Q&&{synpred1_t}?->:s6=>1\n.s5-{synpred1_t}?->:s6=>1\n.s5-{true}?->:s7=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testRecursionOverflowWithPredOk2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : (a Y)=> a Y | A A A A A X | Z;\na : A a | Q;");
        String string = ".s0-A->.s1\n.s0-Q&&{synpred1_t}?->:s11=>1\n.s0-Z->:s12=>3\n.s1-A->.s2\n.s1-Q&&{synpred1_t}?->:s10=>1\n.s2-A->.s3\n.s2-Q&&{synpred1_t}?->:s9=>1\n.s3-A->.s4\n.s3-Q&&{synpred1_t}?->:s8=>1\n.s4-A->.s5\n.s4-Q&&{synpred1_t}?->:s6=>1\n.s5-{synpred1_t}?->:s6=>1\n.s5-{true}?->:s7=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testCannotSeePastRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx   : y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        List<Object> list = Arrays.asList(new Integer(1), new Integer(2));
        this.assertNonLLStar(grammar, list);
    }

    public void testSynPredResolvesRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx   : (y X)=> y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String string = ".s0-B->.s4\n.s0-L->.s1\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{synpred1_t}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSemPredResolvesRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx   : {p}? y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String string = ".s0-B->.s4\n.s0-L->.s1\n.s1-{p}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{p}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSemPredResolvesRecursion2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx\noptions {k=1;}\n   : {p}? y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String string = ".s0-B->.s4\n.s0-L->.s1\n.s1-{p}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{p}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSemPredResolvesRecursion3() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx\noptions {k=2;}\n   : {p}? y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String string = ".s0-B->.s6\n.s0-L->.s1\n.s1-B->.s5\n.s1-L->.s2\n.s2-{p}?->:s3=>1\n.s2-{true}?->:s4=>2\n.s5-{p}?->:s3=>1\n.s5-{true}?->:s4=>2\n.s6-X->:s3=>1\n.s6-Y->:s4=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSynPredResolvesRecursion2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nstatement\n    :     (reference ASSIGN)=> reference ASSIGN expr\n    |     expr\n    ;\nexpr:     reference\n    |     INT\n    |     FLOAT\n    ;\nreference\n    :     ID L argument_list R\n    ;\nargument_list\n    :     expr COMMA expr\n    ;");
        String string = ".s0-ID->.s1\n.s0-INT..FLOAT->:s3=>2\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSynPredResolvesRecursion3() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nstatement\noptions {k=1;}\n    :     (reference ASSIGN)=> reference ASSIGN expr\n    |     expr\n    ;\nexpr:     reference\n    |     INT\n    |     FLOAT\n    ;\nreference\n    :     ID L argument_list R\n    ;\nargument_list\n    :     expr COMMA expr\n    ;");
        String string = ".s0-ID->.s1\n.s0-INT..FLOAT->:s3=>2\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSynPredResolvesRecursion4() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nstatement\noptions {k=2;}\n    :     (reference ASSIGN)=> reference ASSIGN expr\n    |     expr\n    ;\nexpr:     reference\n    |     INT\n    |     FLOAT\n    ;\nreference\n    :     ID L argument_list R\n    ;\nargument_list\n    :     expr COMMA expr\n    ;");
        String string = ".s0-ID->.s1\n.s0-INT..FLOAT->:s4=>2\n.s1-L->.s2\n.s2-{synpred1_t}?->:s3=>1\n.s2-{true}?->:s4=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testSynPredResolvesRecursionInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA :     (B ';')=> B ';'\n  |     B '.'\n  ;\nfragment\nB :     '(' B ')'\n  |     'x'\n  ;\n");
        String string = ".s0-'('->.s1\n.s0-'x'->.s4\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{synpred1_t}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testAutoBacktrackResolvesRecursionInLexer() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\noptions {backtrack=true;}\nA :     B ';'\n  |     B '.'\n  ;\nfragment\nB :     '(' B ')'\n  |     'x'\n  ;\n");
        String string = ".s0-'('->.s1\n.s0-'x'->.s4\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{synpred1_t}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testAutoBacktrackResolvesRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\noptions {backtrack=true;}\nx   : y X\n    | y Y\n    ;\ny   : L y R\n    | B\n    ;");
        String string = ".s0-B->.s4\n.s0-L->.s1\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n.s4-{synpred1_t}?->:s2=>1\n.s4-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testselfRecurseNonDet2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : P a P | P;");
        String string = ".s0-P->.s1\n.s1-EOF->:s2=>2\n.s1-P->:s3=>1\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "P P";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testIndirectRecursionLoop() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : b X ;\nb : a B ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
                this.add("b");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
        grammar.createLookaheadDFAs(false);
        Message message = (Message)errorQueue.warnings.get(0);
        TestDFAConversion.assertTrue((String)new StringBuffer().append("expecting left recursion cycles; found ").append(message.getClass().getName()).toString(), (boolean)(message instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage leftRecursionCyclesMessage = (LeftRecursionCyclesMessage)message;
        Collection collection = leftRecursionCyclesMessage.cycles;
        HashSet hashSet2 = new HashSet(){
            {
                this.add("a");
                this.add("b");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet2, this.ruleNames2(collection));
    }

    public void testIndirectRecursionLoop2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : i b X ;\nb : a B ;\ni : ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
                this.add("b");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
        grammar.createLookaheadDFAs(false);
        Message message = (Message)errorQueue.warnings.get(0);
        TestDFAConversion.assertTrue((String)new StringBuffer().append("expecting left recursion cycles; found ").append(message.getClass().getName()).toString(), (boolean)(message instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage leftRecursionCyclesMessage = (LeftRecursionCyclesMessage)message;
        Collection collection = leftRecursionCyclesMessage.cycles;
        HashSet hashSet2 = new HashSet(){
            {
                this.add("a");
                this.add("b");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet2, this.ruleNames2(collection));
    }

    public void testIndirectRecursionLoop3() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : i b X ;\nb : a B ;\ni : ;\nd : e ;\ne : d ;\n");
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
                this.add("b");
                this.add("e");
                this.add("d");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
        Message message = (Message)errorQueue.warnings.get(0);
        TestDFAConversion.assertTrue((String)new StringBuffer().append("expecting left recursion cycles; found ").append(message.getClass().getName()).toString(), (boolean)(message instanceof LeftRecursionCyclesMessage));
        LeftRecursionCyclesMessage leftRecursionCyclesMessage = (LeftRecursionCyclesMessage)message;
        Collection collection = leftRecursionCyclesMessage.cycles;
        HashSet hashSet2 = new HashSet(){
            {
                this.add("a");
                this.add("b");
                this.add("d");
                this.add("e");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet2, this.ruleNames2(collection));
    }

    public void testifThenElse() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : IF s (E s)? | B;\nslist: s SEMI ;");
        String string = ".s0-E->:s1=>1\n.s0-SEMI->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "E";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
        string = ".s0-B->:s2=>2\n.s0-IF->:s1=>1\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, 0);
    }

    public void testifThenElseChecksStackSuffixConflict() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nslist: s SEMI ;\ns : IF s el | B;\nel: (E s)? ;\n");
        String string = ".s0-E->:s1=>1\n.s0-SEMI->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "E";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 2, string, nArray, nArray2, string2, nArray3, n);
        string = ".s0-B->:s2=>2\n.s0-IF->:s1=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testInvokeRule() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : b A\n  | b B\n  | C\n  ;\nb : X\n  ;\n");
        String string = ".s0-C->:s4=>3\n.s0-X->.s1\n.s1-A->:s3=>1\n.s1-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testDoubleInvokeRuleLeftEdge() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : b X\n  | b Y\n  ;\nb : c B\n  | c\n  ;\nc : C ;\n");
        String string = ".s0-C->.s1\n.s1-B->.s4\n.s1-X->:s2=>1\n.s1-Y->:s3=>2\n.s4-X->:s2=>1\n.s4-Y->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
        string = ".s0-C->.s1\n.s1-B->:s3=>1\n.s1-X..Y->:s2=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, 0);
    }

    public void testimmediateTailRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : A a | A B;");
        String string = ".s0-A->.s1\n.s1-A->:s3=>1\n.s1-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAStar_immediateTailRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : A a | ;");
        String string = ".s0-A->:s1=>1\n.s0-EOF->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testNoStartRule() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : A a | X;");
        Tool tool = this.newTool();
        tool.setOutputDirectory(null);
        CodeGenerator codeGenerator = new CodeGenerator(tool, grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        codeGenerator.genRecognizer();
        Message message = (Message)errorQueue.warnings.get(0);
        TestDFAConversion.assertTrue((String)new StringBuffer().append("expecting no start rules; found ").append(message.getClass().getName()).toString(), (boolean)(message instanceof GrammarSemanticsMessage));
    }

    public void testAStar_immediateTailRecursion2() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : A a | A ;");
        String string = ".s0-A->.s1\n.s1-A->:s3=>1\n.s1-EOF->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testimmediateLeftRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : a A | B;");
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
    }

    public void testIndirectLeftRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : b | A ;\nb : c ;\nc : a | C ;\n");
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
    }

    public void testLeftRecursionInMultipleCycles() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a x ;\na : b | A ;\nb : c ;\nc : a | C ;\nx : y | X ;\ny : x ;\n");
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet(){
            {
                this.add("a");
                this.add("b");
                this.add("c");
                this.add("x");
                this.add("y");
            }
        };
        TestDFAConversion.assertEquals((Object)hashSet, this.ruleNames(set));
    }

    public void testCycleInsideRuleDoesNotForceInfiniteRecursion() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a ;\na : (A|)+ B;\n");
        Set<Rule> set = grammar.getLeftRecursiveRules();
        HashSet hashSet = new HashSet();
        TestDFAConversion.assertEquals(hashSet, set);
    }

    public void testAStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A )* ;");
        String string = ".s0-A->:s1=>1\n.s0-EOF->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAorBorCStar() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A | B | C )* ;");
        String string = ".s0-A..C->:s1=>1\n.s0-EOF->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAPlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A )+ ;");
        String string = ".s0-A->:s1=>1\n.s0-EOF->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAPlusNonGreedyWhenDeterministic() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (options {greedy=false;}:A)+ ;\n");
        String string = ".s0-A->:s1=>1\n.s0-EOF->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAPlusNonGreedyWhenNonDeterministic() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (options {greedy=false;}:A)+ A+ ;\n");
        String string = ".s0-A->:s1=>2\n";
        int[] nArray = new int[]{1};
        int[] nArray2 = new int[]{1, 2};
        String string2 = "A";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testAPlusGreedyWhenNonDeterministic() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (options {greedy=true;}:A)+ A+ ;\n");
        String string = ".s0-A->:s1=>1\n";
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{1, 2};
        String string2 = "A";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testAorBorCPlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A | B | C )+ ;");
        String string = ".s0-A..C->:s1=>1\n.s0-EOF->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A )? B ;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAorBorCOptional() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ( A | B | C )? Z ;");
        String string = ".s0-A..C->:s1=>1\n.s0-Z->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testAStarBOrAStarC() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A)* B | (A)* C;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
        string = ".s0-A->:s1=>1\n.s0-C->:s2=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, 0);
        string = ".s0-A->.s1\n.s0-B->:s3=>1\n.s0-C->:s2=>2\n.s1-A->.s1\n.s1-B->:s3=>1\n.s1-C->:s2=>2\n";
        this.checkDecision(grammar, 3, string, null, null, null, null, 0);
    }

    public void testAStarBOrAPlusC() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A)* B | (A)+ C;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
        string = ".s0-A->:s1=>1\n.s0-C->:s2=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, 0);
        string = ".s0-A->.s1\n.s0-B->:s3=>1\n.s1-A->.s1\n.s1-B->:s3=>1\n.s1-C->:s2=>2\n";
        this.checkDecision(grammar, 3, string, null, null, null, null, 0);
    }

    public void testAOrBPlusOrAPlus() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A|B)* X | (A)+ Y;");
        String string = ".s0-A..B->:s1=>1\n.s0-X->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
        string = ".s0-A->:s1=>1\n.s0-Y->:s2=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, 0);
        string = ".s0-A->.s1\n.s0-B..X->:s3=>1\n.s1-A->.s1\n.s1-B..X->:s3=>1\n.s1-Y->:s2=>2\n";
        this.checkDecision(grammar, 3, string, null, null, null, null, 0);
    }

    public void testLoopbackAndExit() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A|B)+ B;");
        String string = ".s0-A->:s2=>1\n.s0-B->.s1\n.s1-A..B->:s2=>1\n.s1-EOF->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testOptionalAltAndBypass() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A|B)? B;");
        String string = ".s0-A->:s2=>1\n.s0-B->.s1\n.s1-B->:s2=>1\n.s1-EOF->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testResolveLL1ByChoosingFirst() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A C | A C;");
        String string = ".s0-A->.s1\n.s1-C->:s2=>1\n";
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{1, 2};
        String string2 = "A C";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testResolveLL2ByChoosingFirst() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A B | A B;");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n";
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{1, 2};
        String string2 = "A B";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testResolveLL2MixAlt() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A B | A C | A B | Z;");
        String string = ".s0-A->.s1\n.s0-Z->:s4=>4\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n";
        int[] nArray = new int[]{3};
        int[] nArray2 = new int[]{1, 3};
        String string2 = "A B";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testIndirectIFThenElseStyleAmbig() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : stat ;\nstat : LCURLY ( cg )* RCURLY | E SEMI  ;\ncg : (c)+ (stat)* ;\nc : CASE E ;\n");
        String string = ".s0-CASE->:s2=>1\n.s0-LCURLY..E->:s1=>2\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "CASE";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testComplement() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ~(A | B | C) | C {;} ;\nb : X Y Z ;");
        String string = ".s0-C->:s2=>2\n.s0-X..Z->:s1=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testComplementToken() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : ~C | C {;} ;\nb : X Y Z ;");
        String string = ".s0-C->:s2=>2\n.s0-X..Z->:s1=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testComplementChar() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ~'x' | 'x' {;} ;\n");
        String string = ".s0-'x'->:s2=>2\n.s0-{'\\u0000'..'w', 'y'..'\\uFFFE'}->:s1=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testComplementCharSet() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : ~(' '|'\t'|'x'|'y') | 'x';\nB : 'y' ;");
        String string = ".s0-'y'->:s2=>2\n.s0-{'\\u0000'..'\\b', '\\n'..'\\u001F', '!'..'x', 'z'..'\\uFFFE'}->:s1=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testNoSetCollapseWithActions() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A | B {foo}) | C;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testRuleAltsSetCollapse() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A | B | C ;");
        String string = " ( grammar t ( rule a ARG RET scope ( BLOCK ( ALT A <end-of-alt> ) ( ALT B <end-of-alt> ) ( ALT C <end-of-alt> ) <end-of-block> ) <end-of-rule> ) )";
        TestDFAConversion.assertEquals((String)string, (String)grammar.getGrammarTree().toStringTree());
    }

    public void testTokensRuleAltsDoNotCollapse() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';B : 'b';\n");
        String string = ".s0-'a'->:s1=>1\n.s0-'b'->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testMultipleSequenceCollision() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : (A{;}|B)\n  | (A{;}|B)\n  | A\n  ;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>1\n";
        int[] nArray = new int[]{2, 3};
        int[] nArray2 = new int[]{1, 2, 3};
        String string2 = "A";
        int[] nArray3 = null;
        int n = 3;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testMultipleAltsSameSequenceCollision() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : type ID \n  | type ID\n  | type ID\n  | type ID\n  ;\n\ntype : I | F;");
        String string = ".s0-I..F->.s1\n.s1-ID->:s2=>1\n";
        int[] nArray = new int[]{2, 3, 4};
        int[] nArray2 = new int[]{1, 2, 3, 4};
        String string2 = "I..F ID";
        int[] nArray3 = null;
        int n = 2;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testFollowReturnsToLoopReenteringSameRule() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nsl : L ( esc | ~(R|SLASH) )* R ;\n\nesc : SLASH ( N | D03 (D07)? ) ;");
        String string = ".s0-R->:s3=>3\n.s0-SLASH->:s1=>1\n.s0-{L, N..D07}->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "D07";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testTokenCallsAnotherOnLeftEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nF   :   I '.'\n    ;\nI   :   '0'\n    ;\n");
        String string = ".s0-'0'->.s1\n.s1-'.'->:s3=>1\n.s1-<EOT>->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    public void testSelfRecursionAmbigAlts() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : a;\na   :   L ID R\n    |   L a R\n    |   b\n    ;\n\nb   :   ID\n    ;\n");
        String string = ".s0-ID->:s5=>3\n.s0-L->.s1\n.s1-ID->.s2\n.s1-L->:s4=>2\n.s2-R->:s3=>1\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "L ID R";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testIndirectRecursionAmbigAlts() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns   :   a ;\na   :   L ID R\n    |   b\n    ;\n\nb   :   ID\n    |   L a R\n    ;");
        String string = ".s0-ID->:s4=>2\n.s0-L->.s1\n.s1-ID->.s2\n.s1-L->:s4=>2\n.s2-R->:s3=>1\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "L ID R";
        int[] nArray3 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testTailRecursionInvokedFromArbitraryLookaheadDecision() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : b X\n  | b Y\n  ;\n\nb : A\n  | A b\n  ;\n");
        List<Object> list = Arrays.asList(new Integer(1), new Integer(2));
        this.assertNonLLStar(grammar, list);
    }

    public void testWildcardStarK1AndNonGreedyByDefaultInParser() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : A block EOF ;\nblock : L .* R ;");
        String string = ".s0-A..L->:s2=>1\n.s0-R->:s1=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testWildcardPlusK1AndNonGreedyByDefaultInParser() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\ns : A block EOF ;\nblock : L .+ R ;");
        String string = ".s0-A..L->:s2=>1\n.s0-R->:s1=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
    }

    public void testGatedSynPred() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx   : (X)=> X\n    | Y\n    ;\n");
        String string = ".s0-X&&{synpred1_t}?->:s1=>1\n.s0-Y->:s2=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
        Set<String> set = grammar.synPredNamesUsedInDFA;
        HashSet<String> hashSet = new HashSet<String>(){
            {
                this.add("synpred1_t");
            }
        };
        TestDFAConversion.assertEquals((String)"predicate names not recorded properly in grammar", (Object)hashSet, set);
    }

    public void testHoistedGatedSynPred() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\nx   : (X)=> X\n    | X\n    ;\n");
        String string = ".s0-X->.s1\n.s1-{synpred1_t}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int n = 0;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, n);
        Set<String> set = grammar.synPredNamesUsedInDFA;
        HashSet<String> hashSet = new HashSet<String>(){
            {
                this.add("synpred1_t");
            }
        };
        TestDFAConversion.assertEquals((String)"predicate names not recorded properly in grammar", (Object)hashSet, set);
    }

    public void testCyclicTableCreation() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A+ X | A+ Y ;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
    }

    public void _template() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A | B;");
        String string = "\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, 0);
    }

    protected void assertNonLLStar(Grammar grammar, List list) {
        NonRegularDecisionMessage nonRegularDecisionMessage;
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        TestDFAConversion.assertTrue((String)"expected fatal non-LL(*) msg", ((nonRegularDecisionMessage = this.getNonRegularDecisionMessage(errorQueue.errors)) != null ? 1 : 0) != 0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(nonRegularDecisionMessage.altsWithRecursion);
        Collections.sort(arrayList);
        TestDFAConversion.assertEquals((Object)list, arrayList);
    }

    protected void assertRecursionOverflow(Grammar grammar, List list, int n) {
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        RecursionOverflowMessage recursionOverflowMessage = this.getRecursionOverflowMessage(errorQueue.errors);
        TestDFAConversion.assertTrue((String)new StringBuffer().append("missing expected recursion overflow msg").append(recursionOverflowMessage).toString(), (recursionOverflowMessage != null ? 1 : 0) != 0);
        TestDFAConversion.assertEquals((String)"target rules mismatch", (String)list.toString(), (String)recursionOverflowMessage.targetRules.toString());
        TestDFAConversion.assertEquals((String)"mismatched alt", (int)n, (int)recursionOverflowMessage.alt);
    }

    protected void checkDecision(Grammar grammar, int n, String string, int[] nArray, int[] nArray2, String string2, int[] nArray3, int n2) throws Exception {
        Object object;
        List<Label> list;
        Object object2;
        Object object3;
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        CodeGenerator codeGenerator = new CodeGenerator(this.newTool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (errorQueue.size() != n2) {
            System.err.println(new StringBuffer().append("Warnings issued: ").append(errorQueue).toString());
        }
        TestDFAConversion.assertEquals((String)"unexpected number of expected problems", (int)n2, (int)errorQueue.size());
        DFA dFA = grammar.getLookaheadDFA(n);
        TestDFAConversion.assertNotNull((String)new StringBuffer().append("no DFA for decision ").append(n).toString(), (Object)dFA);
        FASerializer fASerializer = new FASerializer(grammar);
        String string3 = fASerializer.serialize(dFA.startState);
        List<Integer> list2 = dFA.getUnreachableAlts();
        if (nArray != null) {
            object3 = new BitSet();
            ((BitSet)object3).addAll(nArray);
            object2 = new BitSet();
            ((BitSet)object2).addAll(list2);
            TestDFAConversion.assertEquals((String)"unreachable alts mismatch", (Object)object3, (Object)object2);
        } else {
            TestDFAConversion.assertEquals((String)"number of unreachable alts", (int)0, (int)(list2 != null ? list2.size() : 0));
        }
        if (string2 != null) {
            object3 = (Message)errorQueue.warnings.get(0);
            TestDFAConversion.assertTrue((String)new StringBuffer().append("expecting nondeterminism; found ").append(object3.getClass().getName()).toString(), (boolean)(object3 instanceof GrammarNonDeterminismMessage));
            object2 = this.getNonDeterminismMessage(errorQueue.warnings);
            list = ((GrammarNonDeterminismMessage)object2).probe.getSampleNonDeterministicInputSequence(((GrammarNonDeterminismMessage)object2).problemState);
            object = ((GrammarNonDeterminismMessage)object2).probe.getInputSequenceDisplay(list);
            TestDFAConversion.assertEquals((String)string2, (String)object);
        }
        if (nArray2 != null) {
            object3 = null;
            object2 = this.getNonDeterminismMessage(errorQueue.warnings);
            list = null;
            if (object2 != null) {
                list = ((GrammarNonDeterminismMessage)object2).probe.getNonDeterministicAltsForState(((GrammarNonDeterminismMessage)object2).problemState);
            } else {
                object3 = this.getRecursionOverflowMessage(errorQueue.warnings);
                if (object3 != null) {
                    // empty if block
                }
            }
            object = new BitSet();
            ((BitSet)object).addAll(nArray2);
            BitSet bitSet = new BitSet();
            bitSet.addAll(list);
            TestDFAConversion.assertEquals((String)"nondet alts mismatch", (Object)object, (Object)bitSet);
            TestDFAConversion.assertTrue((String)new StringBuffer().append("found no nondet alts; expecting: ").append(this.str(nArray2)).toString(), (object2 != null || object3 != null ? 1 : 0) != 0);
        } else {
            object3 = this.getNonDeterminismMessage(errorQueue.warnings);
            TestDFAConversion.assertNull((String)"found nondet alts, but expecting none", (Object)object3);
        }
        TestDFAConversion.assertEquals((String)string, (String)string3);
    }

    protected GrammarNonDeterminismMessage getNonDeterminismMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof GrammarNonDeterminismMessage)) continue;
            return (GrammarNonDeterminismMessage)message;
        }
        return null;
    }

    protected NonRegularDecisionMessage getNonRegularDecisionMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof NonRegularDecisionMessage)) continue;
            return (NonRegularDecisionMessage)message;
        }
        return null;
    }

    protected RecursionOverflowMessage getRecursionOverflowMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof RecursionOverflowMessage)) continue;
            return (RecursionOverflowMessage)message;
        }
        return null;
    }

    protected LeftRecursionCyclesMessage getLeftRecursionCyclesMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof LeftRecursionCyclesMessage)) continue;
            return (LeftRecursionCyclesMessage)message;
        }
        return null;
    }

    protected GrammarDanglingStateMessage getDanglingStateMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof GrammarDanglingStateMessage)) continue;
            return (GrammarDanglingStateMessage)message;
        }
        return null;
    }

    protected String str(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            int n = nArray[i];
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    protected Set<String> ruleNames(Set<Rule> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Rule rule : set) {
            hashSet.add(rule.name);
        }
        return hashSet;
    }

    protected Set<String> ruleNames2(Collection<HashSet> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (HashSet hashSet2 : collection) {
            hashSet.addAll(this.ruleNames(hashSet2));
        }
        return hashSet;
    }
}

