/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.dbgp.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.DbgpWorkingThread;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.wst.xquery.debug.dbgp.DbgpRequestParser;
import org.eclipse.wst.xquery.debug.dbgp.client.IDbgpCommandListener;

public class DbgpProxyClientReceiver
extends DbgpWorkingThread
implements IDbgpTerminationListener {
    private final InputStream fInputStream;
    private final Queue<DbgpRequest> fCommandQueue = new ConcurrentLinkedQueue<DbgpRequest>();
    List<IDbgpCommandListener> fListeners = new ArrayList<IDbgpCommandListener>(1);
    private final Object fTerminatedLock = new Object();
    private boolean fTerminated = false;
    private DbgpWorkingThread fTranslator;

    public DbgpProxyClientReceiver(DbgpWorkingThread translator, InputStream inputStream) {
        super(DbgpProxyClientReceiver.class.getSimpleName());
        this.fInputStream = inputStream;
        this.fTranslator = translator;
        this.fTranslator.addTerminationListener((IDbgpTerminationListener)this);
    }

    protected void workingCycle() throws Exception {
        try {
            while (!this.fTerminated) {
                StringBuffer sb = new StringBuffer();
                int c = this.fInputStream.read();
                while (c != -1 && c != 0) {
                    sb.append((char)c);
                    c = this.fInputStream.read();
                }
                if (c != 0) continue;
                this.enqueueCommand(DbgpRequestParser.parse(sb.toString()));
            }
        }
        catch (IOException ioe) {
            System.err.println("Receiver exception: " + ioe.getMessage());
            System.out.println("Receiver exception: terminating receiver");
        }
        catch (DbgpException de) {
            System.err.println("Receiver exception: " + de.getMessage());
            System.out.println("Receiver exception: terminating receiver");
        }
    }

    public DbgpRequest retrieveCommand() {
        return this.fCommandQueue.poll();
    }

    public boolean hasAvailableCommand() {
        return !this.fCommandQueue.isEmpty();
    }

    private void enqueueCommand(DbgpRequest request) {
        this.fCommandQueue.offer(request);
        System.out.println("enqueued: " + request.toString());
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (IDbgpCommandListener listener : this.fListeners) {
            listener.commandReceived();
        }
    }

    public void addCommandListener(IDbgpCommandListener listener) {
        this.fListeners.add(listener);
    }

    public void removeCommandListener(IDbgpCommandListener listener) {
        this.fListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectTerminated(Object object, Exception e) {
        Object object2 = this.fTerminatedLock;
        synchronized (object2) {
            if (this.fTerminated) {
                return;
            }
            try {
                this.fInputStream.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.fTranslator.removeTerminationListener((IDbgpTerminationListener)this);
            try {
                this.fTranslator.waitTerminated();
            }
            catch (InterruptedException interruptedException) {}
            this.fTerminated = true;
        }
        this.fireObjectTerminated(e);
    }
}

