/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.ExclusionStrategy;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModifierBasedExclusionStrategy
implements ExclusionStrategy {
    private final boolean skipSyntheticField;
    private final Collection<Integer> modifiers;

    public ModifierBasedExclusionStrategy(boolean skipSyntheticFields, int ... modifiers) {
        this.skipSyntheticField = skipSyntheticFields;
        this.modifiers = new HashSet<Integer>();
        if (modifiers != null) {
            int[] nArray = modifiers;
            int n = modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                int modifier = nArray[n2];
                this.modifiers.add(modifier);
                ++n2;
            }
        }
    }

    @Override
    public boolean shouldSkipField(Field f) {
        if (this.skipSyntheticField && f.isSynthetic()) {
            return true;
        }
        int objectModifiers = f.getModifiers();
        for (int modifier : this.modifiers) {
            if ((objectModifiers & modifier) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        return false;
    }
}

