/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.debugger.zorba.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.xquery.debug.debugger.zorba.preferences.ZorbaDebuggerPreferencePage;
import org.eclipse.wst.xquery.debug.ui.preferences.TranslatableDebuggingEngineOptionsBlock;

public class ZorbaDebuggerBlock
extends TranslatableDebuggingEngineOptionsBlock {
    private Spinner fCommandPortSpinner;
    private Spinner fEventPortSpinner;

    public ZorbaDebuggerBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    protected PreferenceKey getLogFileNamePreferenceKey() {
        return ZorbaDebuggerPreferencePage.LOG_FILE_NAME;
    }

    protected PreferenceKey getDebuggingEngineDbgpTranslatorEnabledKey() {
        return ZorbaDebuggerPreferencePage.ENGINE_NEEDS_DBGP_TRANSLATOR;
    }

    protected void createEngineBlock(Composite parent) {
    }

    private Spinner addPortSpinner(String labelText, Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(parent, 133120);
        spinner.setLayoutData((Object)new GridData(768));
        spinner.setMinimum(1024);
        spinner.setMaximum(65535);
        spinner.setIncrement(1);
        spinner.setPageIncrement(100);
        return spinner;
    }

    protected void addOptions(Composite parent) {
        final Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)4);
        this.fDbgpTranslatorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comp.setEnabled(ZorbaDebuggerBlock.this.needsTranslator());
                ZorbaDebuggerBlock.this.setSpinnersEnabled(ZorbaDebuggerBlock.this.needsTranslator());
            }
        });
        this.fCommandPortSpinner = this.addPortSpinner("Command port:", comp);
        this.fEventPortSpinner = this.addPortSpinner("Event port:", comp);
    }

    protected void initialize() {
        super.initialize();
        this.setSpinnersEnabled(this.needsTranslator());
        String portStr = this.getString(ZorbaDebuggerPreferencePage.ENGINE_SERVER_PORTS);
        String[] ports = portStr.split(":");
        int port = 28028;
        try {
            port = Integer.parseInt(ports[0]);
        }
        catch (NumberFormatException numberFormatException) {}
        this.fCommandPortSpinner.setSelection(port);
        port = 28029;
        try {
            port = Integer.parseInt(ports[1]);
        }
        catch (NumberFormatException numberFormatException) {}
        this.fEventPortSpinner.setSelection(port);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        this.setString(ZorbaDebuggerPreferencePage.ENGINE_SERVER_PORTS, String.valueOf(this.fCommandPortSpinner.getSelection()) + ":" + this.fEventPortSpinner.getSelection());
        return super.processChanges(container);
    }

    private void setSpinnersEnabled(boolean enabled) {
        int backColor = enabled ? 25 : 22;
        int foreColor = enabled ? 21 : 33;
        Composite comp = this.fCommandPortSpinner.getParent();
        this.fCommandPortSpinner.setBackground(comp.getDisplay().getSystemColor(backColor));
        this.fCommandPortSpinner.setForeground(comp.getDisplay().getSystemColor(foreColor));
        this.fEventPortSpinner.setBackground(comp.getDisplay().getSystemColor(backColor));
        this.fEventPortSpinner.setForeground(comp.getDisplay().getSystemColor(foreColor));
    }
}

