/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.debug.ui.interpreters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.IScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xquery.core.XQDTCorePlugin;
import org.eclipse.wst.xquery.debug.ui.XQDTDebugUIPlugin;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractAddInterpreterDialogBlock;
import org.eclipse.wst.xquery.debug.ui.interpreters.AddLocalInterpreterDialogBlock;

public class GenericAddInterpreterDialog
extends StatusDialog
implements IScriptInterpreterDialog,
IStatusChangeListener {
    protected final IAddInterpreterDialogRequestor fRequestor;
    private IInterpreterInstallType[] fInterpreterTypes;
    private IInterpreterInstallType fSelectedInterpreterType;
    private final IInterpreterInstall fEditedInterpreter;
    private int fPrevIndex = -1;
    private IEnvironment fEnvironment;
    private ComboDialogField fInterpreterTypeCombo;
    private Composite fDialogBlockContainer;
    private AbstractAddInterpreterDialogBlock fDialogBlock;
    private IInterpreterInstall lastInstall = null;

    public GenericAddInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fInterpreterTypes = interpreterInstallTypes;
        this.fSelectedInterpreterType = editedInterpreter != null ? editedInterpreter.getInterpreterInstallType() : interpreterInstallTypes[0];
        this.fEditedInterpreter = editedInterpreter;
    }

    public boolean execute() {
        return this.open() == 0;
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
        ((GridData)button.getLayoutData()).grabExcessHorizontalSpace = true;
    }

    public void updateStatusLine() {
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    public void create() {
        super.create();
        this.fDialogBlock.setFocus();
        this.selectInterpreterType();
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        int numColumns = 3;
        this.fDialogBlockContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.fDialogBlockContainer.setLayout((Layout)layout);
        this.fDialogBlockContainer.setLayoutData((Object)new GridData(1808));
        this.fInterpreterTypeCombo = new ComboDialogField(8);
        this.fInterpreterTypeCombo.setLabelText(this.getInterpreterTypeLabel());
        this.fInterpreterTypeCombo.doFillIntoGrid(this.fDialogBlockContainer, 2);
        GridData gd = (GridData)this.fInterpreterTypeCombo.getComboControl(null).getLayoutData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000008;
        this.createAddInterpreterDialogBlock();
        this.fDialogBlock.createControls(this.fDialogBlockContainer);
        this.initializeFields(this.fEditedInterpreter);
        this.createFieldListeners();
        GenericAddInterpreterDialog.applyDialogFont((Control)this.fDialogBlockContainer);
        return parent;
    }

    private void doOkPressed() {
        if (this.fEditedInterpreter == null) {
            InterpreterStandin install = new InterpreterStandin(this.fSelectedInterpreterType, this.createUniqueId(this.fSelectedInterpreterType));
            this.setFieldValuesToInterpreter((IInterpreterInstall)install);
            this.fRequestor.interpreterAdded((IInterpreterInstall)install);
            this.lastInstall = install;
        } else {
            this.setFieldValuesToInterpreter(this.fEditedInterpreter);
            this.lastInstall = this.fEditedInterpreter;
        }
    }

    private String createUniqueId(IInterpreterInstallType InterpreterType) {
        String id = null;
        while (InterpreterType.findInterpreterInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToInterpreter(IInterpreterInstall install) {
        this.fDialogBlock.setFieldValuesToInterpreter(install);
    }

    private void updateInterpreterType() {
        int selIndex;
        boolean redrawBlock = false;
        if (this.fPrevIndex != -1) {
            redrawBlock = true;
        }
        if ((selIndex = this.fInterpreterTypeCombo.getSelectionIndex()) == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fInterpreterTypes.length) {
            this.fSelectedInterpreterType = this.fInterpreterTypes[selIndex];
        }
        if (redrawBlock) {
            this.createAddInterpreterDialogBlock();
            this.fDialogBlock.createControls(this.fDialogBlockContainer);
            this.fDialogBlock.initializeFields(null);
            this.fDialogBlock.createFieldListeners();
            this.fDialogBlockContainer.layout(true);
            this.fDialogBlockContainer.getParent().pack();
            this.getShell().pack();
        }
        this.updateStatusLine();
    }

    public IEnvironment getEnvironment() {
        return this.fEnvironment;
    }

    public void setEnvironment(IEnvironment environment) {
        this.fEnvironment = environment;
    }

    public IInterpreterInstallType[] getInterpreterTypes() {
        return this.fInterpreterTypes;
    }

    protected IInterpreterInstall getLastInterpreterInstall() {
        return this.lastInstall;
    }

    protected void createFieldListeners() {
        this.fInterpreterTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                GenericAddInterpreterDialog.this.updateInterpreterType();
            }
        });
        this.fDialogBlock.createFieldListeners();
    }

    private void createAddInterpreterDialogBlock() {
        if (this.fDialogBlock != null) {
            this.fDialogBlock.dispose();
            this.fDialogBlock = null;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.debug.ui", "interpreterInstallTypeAddDialogBlock");
        if (this.fSelectedInterpreterType == null) {
            XQDTDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.xquery.debug.ui", "No IInterpreterInstallType definition can be associated with this environment: " + this.getEnvironment().getClass().getName()));
            return;
        }
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            block8: {
                String id = infos[i].getAttribute("interpreterInstallTypeID");
                if (this.fSelectedInterpreterType.getId().equals(id)) {
                    try {
                        this.fDialogBlock = (AbstractAddInterpreterDialogBlock)infos[i].createExecutableExtension("class");
                        break;
                    }
                    catch (CoreException e) {
                        if (!XQDTCorePlugin.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        if (this.fDialogBlock == null && this.getEnvironment() == EnvironmentManager.getLocalEnvironment()) {
            this.fDialogBlock = new AddLocalInterpreterDialogBlock();
        }
        if (this.fDialogBlock == null) {
            XQDTDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.xquery.debug.ui", "No AbstractAddInterpreterDialogBlock definition was found for the interpreter install type: " + this.fSelectedInterpreterType.getClass().getName() + ". Use the org.eclipse.wst.xquery.debug.ui.interpreterInstallTypeAddDialogBlock extension point to provide one."));
            return;
        }
        this.fDialogBlock.initialize(this, this.fRequestor, this.fEditedInterpreter);
    }

    public IInterpreterInstallType getInterpreterType() {
        return this.fSelectedInterpreterType;
    }

    private String[] getInterpreterTypeNames() {
        String[] names = new String[this.fInterpreterTypes.length];
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            names[i] = this.fInterpreterTypes[i].getName();
            ++i;
        }
        return names;
    }

    protected String getInterpreterTypeLabel() {
        return InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentType;
    }

    protected String getInterpreterNameLabel() {
        return InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName;
    }

    private void selectInterpreterType() {
        int i = 0;
        while (i < this.fInterpreterTypes.length) {
            if (this.fSelectedInterpreterType == this.fInterpreterTypes[i]) {
                this.fInterpreterTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }

    public int convertVerticalDLUsToPixels(int dlus) {
        return super.convertVerticalDLUsToPixels(dlus);
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        return super.convertHorizontalDLUsToPixels(dlus);
    }

    protected void initializeFields(IInterpreterInstall install) {
        this.fInterpreterTypeCombo.setItems(this.getInterpreterTypeNames());
        if (install != null) {
            this.fInterpreterTypeCombo.setText(install.getInterpreterInstallType().getName());
            this.fInterpreterTypeCombo.setEnabled(false);
        }
        this.fDialogBlock.initializeFields(install);
        this.updateStatusLine();
    }

    public void statusChanged(IStatus status) {
        this.updateStatus(status);
    }
}

