/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.debug.ui.interpreters;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.launching.LazyFileHandle;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractAddInterpreterDialogBlock;
import org.eclipse.wst.xquery.debug.ui.interpreters.AbstractInterpreterEnvironmentVariablesBlock;

public class XQDTJavaInterpreterAddInterpreterDialogBlock
extends AbstractAddInterpreterDialogBlock {
    private static final String INTERPRETER_LOCATION_LABEL_NAME = "Interpreter JAR/WAR:";
    private static final String INTERPRETER_MAIN_CLASS_LABEL_NAME = "Main class:";
    public static final String[] POSSIBLE_EXTENSION_FILTER = new String[]{"*.jar;*.war"};
    protected StringDialogField fInterpreterNameField;
    protected StringButtonDialogField fInterpreterLocationField;
    protected StringDialogField fInterpreterMainClassField;
    protected StringDialogField fInterpreterArgsField;
    protected AbstractInterpreterEnvironmentVariablesBlock fEnvironmentVariablesBlock;
    private IStatus[] fStati = new IStatus[5];

    public XQDTJavaInterpreterAddInterpreterDialogBlock() {
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
    }

    protected void addControlsTo(Composite parent) {
        Button button;
        int numColumns = 3;
        this.fInterpreterNameField = new StringDialogField();
        this.fInterpreterNameField.setLabelText(InterpretersMessages.addInterpreterDialog_InterpreterEnvironmentName);
        this.fInterpreterNameField.doFillIntoGrid(parent, numColumns);
        this.fInterpreterLocationField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.browseForInstallation();
            }
        });
        this.fInterpreterLocationField.setLabelText(INTERPRETER_LOCATION_LABEL_NAME);
        this.fInterpreterLocationField.setButtonLabel(InterpretersMessages.addInterpreterDialog_browse1);
        this.fInterpreterLocationField.doFillIntoGrid(parent, numColumns);
        ((GridData)this.fInterpreterLocationField.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fInterpreterMainClassField = new StringDialogField();
        this.fInterpreterMainClassField.setLabelText(INTERPRETER_MAIN_CLASS_LABEL_NAME);
        boolean foundJDTSearchTools = this.findJdtSearchTools();
        if (foundJDTSearchTools) {
            this.fInterpreterMainClassField.doFillIntoGrid(parent, numColumns - 1);
            button = new Button(parent, 8);
            button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            button.setText("Search...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XQDTJavaInterpreterAddInterpreterDialogBlock.this.searchForJavaMainClass();
                }
            });
        } else {
            this.fInterpreterMainClassField.doFillIntoGrid(parent, numColumns);
        }
        this.fInterpreterArgsField = new StringDialogField();
        this.fInterpreterArgsField.setLabelText(InterpretersMessages.AddInterpreterDialog_iArgs);
        this.fInterpreterArgsField.doFillIntoGrid(parent, numColumns - 1);
        button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("Variables...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(XQDTJavaInterpreterAddInterpreterDialogBlock.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    XQDTJavaInterpreterAddInterpreterDialogBlock.this.fInterpreterArgsField.getTextControl(null).insert(variable);
                }
            }
        });
        this.fEnvironmentVariablesBlock = this.createEnvironmentVariablesBlock();
        if (this.fEnvironmentVariablesBlock != null) {
            Label l = new Label(parent, 0);
            l.setText(InterpretersMessages.AddScriptInterpreterDialog_interpreterEnvironmentVariables);
            GridData gd = new GridData(768);
            gd.horizontalSpan = numColumns;
            l.setLayoutData((Object)gd);
            Control block = this.fEnvironmentVariablesBlock.createControl(parent);
            gd = new GridData(1808);
            gd.horizontalSpan = numColumns;
            block.setLayoutData((Object)gd);
        }
    }

    protected AbstractInterpreterEnvironmentVariablesBlock createEnvironmentVariablesBlock() {
        return null;
    }

    public void setFieldValuesToInterpreter(IInterpreterInstall install) {
        IEnvironment selectedEnv = this.fAddInterpreterDialog.getEnvironment();
        install.setInstallLocation((IFileHandle)new LazyFileHandle(selectedEnv.getId(), (IPath)new Path(this.getInterpreterLocation())));
        install.setName(this.getInterpreterName());
        String args = String.valueOf(this.getInterpreterMainClass()) + " " + this.getInterpreterArguments();
        install.setInterpreterArgs(args);
        if (this.fEnvironmentVariablesBlock != null) {
            this.fEnvironmentVariablesBlock.performApply(install);
        }
    }

    protected IStatus validateInterpreterLocation() {
        String pName;
        String name;
        IFileHandle file;
        IEnvironment selectedEnv = this.fAddInterpreterDialog.getEnvironment();
        String locationName = this.getInterpreterLocation();
        StatusInfo s = null;
        if (locationName.length() == 0) {
            file = null;
            s = new StatusInfo(1, InterpretersMessages.addInterpreterDialog_enterLocation);
        } else {
            file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)selectedEnv, (IPath)new Path(locationName));
            if (!file.exists()) {
                s = new StatusInfo(4, InterpretersMessages.addInterpreterDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        temp[0] = XQDTJavaInterpreterAddInterpreterDialogBlock.this.fAddInterpreterDialog.getInterpreterType().validateInstallLocation(file);
                    }
                });
                s = temp[0];
            }
        }
        if (s.isOK() && ((name = this.getInterpreterName()) == null || name.length() == 0) && file != null && (pName = this.generateInterpreterName(file.toOSString())) != null) {
            this.fInterpreterNameField.setText(pName);
        }
        return s;
    }

    protected String getInterpreterMainClass() {
        return this.fInterpreterMainClassField.getText().trim();
    }

    protected String getInterpreterLocation() {
        return this.fInterpreterLocationField.getText().trim();
    }

    protected String getInterpreterArguments() {
        return this.fInterpreterArgsField.getText().trim();
    }

    protected String getInterpreterName() {
        return this.fInterpreterNameField.getText().trim();
    }

    protected void browseForInstallation() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(POSSIBLE_EXTENSION_FILTER);
        String newPath = dialog.open();
        if (newPath != null) {
            this.fInterpreterLocationField.setText(newPath);
        }
    }

    public void initializeFields(IInterpreterInstall install) {
        if (install == null) {
            this.fInterpreterNameField.setText("");
            this.fInterpreterLocationField.setText("");
            this.fInterpreterMainClassField.setText("");
            this.fInterpreterArgsField.setText("");
        } else {
            this.fInterpreterNameField.setText(install.getName());
            this.fInterpreterLocationField.setText(install.getRawInstallLocation().toOSString());
            String mainClass = install.getInterpreterArguments()[0];
            String interpreterArgs = install.getInterpreterArgs();
            interpreterArgs = interpreterArgs.substring(interpreterArgs.indexOf(32));
            this.fInterpreterMainClassField.setText(mainClass);
            this.fInterpreterArgsField.setText(interpreterArgs);
            if (this.fEnvironmentVariablesBlock != null) {
                this.fEnvironmentVariablesBlock.initializeFrom(install, install.getInterpreterInstallType());
            }
        }
        this.setInterpreterNameStatus(this.validateInterpreterName());
        this.setInterpreterLocationStatus(this.validateInterpreterLocation());
        this.setInterpreterMainClassStatus(this.validateInterpreterMainClass());
        this.updateStatus();
    }

    public void createFieldListeners() {
        this.fInterpreterNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.setInterpreterNameStatus(XQDTJavaInterpreterAddInterpreterDialogBlock.this.validateInterpreterName());
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.updateStatus();
            }
        });
        this.fInterpreterLocationField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.setInterpreterLocationStatus(XQDTJavaInterpreterAddInterpreterDialogBlock.this.validateInterpreterLocation());
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.updateStatus();
            }
        });
        this.fInterpreterMainClassField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.setInterpreterMainClassStatus(XQDTJavaInterpreterAddInterpreterDialogBlock.this.validateInterpreterMainClass());
                XQDTJavaInterpreterAddInterpreterDialogBlock.this.updateStatus();
            }
        });
    }

    protected IStatus validateInterpreterMainClass() {
        String mainClass = this.getInterpreterMainClass();
        if (mainClass.length() == 0) {
            return new StatusInfo(1, "Enter the main class from the provided Java archive.");
        }
        if (mainClass.endsWith(".")) {
            return new StatusInfo(4, "The class name cannot terminate with a dot");
        }
        String[] splits = mainClass.split("\\.");
        int i = 0;
        while (i < splits.length) {
            if (splits[i].length() == 0) {
                return new StatusInfo(4, "Invalid class name (zero length fragment)");
            }
            if (!Character.isJavaIdentifierStart(splits[i].charAt(0))) {
                return new StatusInfo(4, "Invalid class name (invalid start character '" + splits[i].charAt(0) + "'for fragment: \"" + splits[i] + "\")");
            }
            int j = 1;
            while (j < splits[i].length()) {
                if (!Character.isJavaIdentifierPart(splits[i].charAt(j))) {
                    return new StatusInfo(4, "Invalid class name (invalid character '" + splits[i].charAt(j) + "' in fragment: \"" + splits[i] + "\")");
                }
                ++j;
            }
            ++i;
        }
        return new StatusInfo();
    }

    public void updateStatus() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.getStatusListener().statusChanged(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.getStatusListener().statusChanged(max);
    }

    private void setInterpreterNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setInterpreterLocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    private void setInterpreterMainClassStatus(IStatus status) {
        this.fStati[2] = status;
    }

    protected IStatus validateInterpreterName() {
        StatusInfo status = new StatusInfo();
        String name = this.getInterpreterName();
        if (name == null || name.length() == 0) {
            status.setInfo(InterpretersMessages.addInterpreterDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedInterpreter == null || !name.equals(this.fEditedInterpreter.getName()))) {
            status.setError(InterpretersMessages.addInterpreterDialog_duplicateName);
        }
        return status;
    }

    public void setFocus() {
        this.fInterpreterNameField.setFocus();
    }

    public String generateInterpreterName(String location) {
        return null;
    }

    private boolean findJdtSearchTools() {
        return false;
    }

    private void searchForJavaMainClass() {
    }
}

