/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.http;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.wst.xquery.marklogic.http.MultipartSplitter;

public class PartInputStream
extends InputStream {
    private MultipartSplitter splitter;

    public PartInputStream(MultipartSplitter splitter) {
        this.splitter = splitter;
    }

    public int available() {
        return 0;
    }

    public void close() {
        this.splitter = null;
    }

    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        if (n == 1) {
            return buf[0];
        }
        return -1;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.splitter == null) {
            throw new IOException("Splitter stream closed");
        }
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new IndexOutOfBoundsException("offset or length error");
        }
        return this.splitter.read(buf, offset, len);
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) throws IOException {
        if (n < 0x40000000L) {
            byte[] buf = new byte[(int)n];
            return this.read(buf, 0, (int)n);
        }
        byte[] buf = new byte[0x40000000];
        long resultLen = 0L;
        long residualLen = n;
        int m = 0x40000000;
        while ((long)m < n) {
            resultLen += (long)this.read(buf, 0, residualLen < 0x40000000L ? (int)residualLen : 0x40000000);
            m += 0x40000000;
            residualLen -= 0x40000000L;
        }
        return resultLen;
    }
}

