/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.exceptions;

import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.RequestServerException;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.XQueryStackFrame;
import org.eclipse.wst.xquery.marklogic.xcc.types.XdmVariable;

public class XQueryException
extends RequestServerException {
    private static final long serialVersionUID = 9187877171979743149L;
    private final String code;
    private final String w3cCode;
    private final String xqueryVersion;
    private final String formatString;
    private final String expr;
    private final boolean retryable;
    private final String[] data;
    private final transient XQueryStackFrame[] stack;

    public XQueryException(Request request, String code, String w3cCode, String xqueryVersion, String message, String formatString, String expr, boolean retryable, String[] data, XQueryStackFrame[] stack) {
        super(message == null || message.length() == 0 ? code : message, request);
        this.code = code;
        this.w3cCode = w3cCode;
        this.xqueryVersion = xqueryVersion;
        this.formatString = formatString;
        this.expr = expr;
        this.retryable = retryable;
        this.data = (String[])data.clone();
        this.stack = (XQueryStackFrame[])stack.clone();
    }

    public String getCode() {
        return this.code;
    }

    public String getW3CCode() {
        return this.w3cCode;
    }

    public String getXQueryVersion() {
        return this.xqueryVersion;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public String[] getData() {
        return (String[])this.data.clone();
    }

    public XQueryStackFrame[] getStack() {
        return (XQueryStackFrame[])this.stack.clone();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ");
        if (this.formatString != null && !this.formatString.equals("")) {
            sb.append(this.formatString);
        } else {
            sb.append(this.code);
            i = 0;
            while (i < this.data.length) {
                sb.append(" ");
                sb.append(this.data[i]);
                ++i;
            }
        }
        if (this.stack != null) {
            i = 0;
            while (i < this.stack.length) {
                XdmVariable[] variables;
                String operation;
                int line;
                XQueryStackFrame frame = this.stack[i];
                boolean b = false;
                String uri = frame.getUri();
                if (uri != null && uri.length() > 0) {
                    b = true;
                    sb.append("\nin ");
                    sb.append(uri);
                }
                if ((line = frame.getLineNumber()) != 0) {
                    if (b) {
                        sb.append(", ");
                    } else {
                        sb.append('\n');
                        b = true;
                    }
                    sb.append("on line ");
                    sb.append(line);
                }
                if (this.expr != null && this.expr.length() != 0) {
                    sb.append("\nexpr: ");
                    sb.append(this.expr);
                }
                if ((operation = frame.getOperation()) != null && operation.length() > 0) {
                    if (b) {
                        sb.append(',');
                    } else {
                        b = true;
                    }
                    sb.append("\nin ");
                    sb.append(operation);
                }
                if ((variables = frame.getVariables()) != null) {
                    int contextPosition;
                    int j = 0;
                    while (j < variables.length) {
                        XdmVariable variable = variables[j];
                        String name = variable.getName().getLocalname();
                        String value = variable.getValue().asString();
                        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
                            sb.append("\n  $");
                            sb.append(name);
                            sb.append(" = ");
                            sb.append(value);
                        }
                        ++j;
                    }
                    String contextItem = frame.getContextItem();
                    if (contextItem != null && contextItem.length() > 0) {
                        sb.append("\n  context-item() = ");
                        sb.append(contextItem);
                    }
                    if ((contextPosition = frame.getContextPosition()) != 0) {
                        sb.append("\n  context-position() = ");
                        sb.append(contextPosition);
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }
}

