/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.marklogic.xcc.types.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.wst.xquery.marklogic.io.IOHelper;
import org.eclipse.wst.xquery.marklogic.xcc.types.ItemType;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.AbstractItem;
import org.eclipse.wst.xquery.marklogic.xcc.types.impl.StreamableItem;

public class AbstractStreamableItem
extends AbstractItem
implements StreamableItem {
    private String stringVal = null;
    private InputStream stream = null;

    public AbstractStreamableItem(ItemType type, String stringVal) {
        super(type);
        this.stringVal = stringVal;
    }

    public AbstractStreamableItem(ItemType type, InputStream stream) {
        super(type);
        this.stream = stream;
    }

    public boolean isFetchable() {
        return this.stringVal != null || this.stream != null;
    }

    public void invalidate() {
        this.stringVal = null;
        if (this.stream != null) {
            try {
                this.stream.skip(Long.MAX_VALUE);
                this.stream.close();
            }
            catch (IOException iOException) {}
            this.stream = null;
        }
    }

    public boolean isCached() {
        return this.stringVal != null;
    }

    public Reader asReader() {
        if (this.stream != null) {
            InputStream tmp = this.stream;
            this.stream = null;
            try {
                return new InputStreamReader(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new InputStreamReader(tmp);
            }
        }
        if (this.stringVal == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        return new StringReader(this.stringVal);
    }

    public InputStream asInputStream() {
        if (this.stream != null) {
            InputStream tmp = this.stream;
            this.stream = null;
            return tmp;
        }
        if (this.stringVal == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        return IOHelper.newUtf8Stream(this.stringVal);
    }

    public String asString() {
        if (this.stringVal != null) {
            return this.stringVal;
        }
        if (this.stream == null) {
            throw new IllegalStateException("value stream has already been consumed");
        }
        try {
            try {
                this.stringVal = IOHelper.literalStringFromStream(this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not buffer value as string", e);
            }
        }
        finally {
            this.stream = null;
        }
        return this.stringVal;
    }
}

