/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.marklogic;

import java.io.BufferedReader;
import java.io.FileReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.wst.xquery.internal.launching.marklogic.MarkLogicInstall;
import org.eclipse.wst.xquery.internal.launching.marklogic.MockStreamsProxy;
import org.eclipse.wst.xquery.marklogic.xcc.AdhocQuery;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.XQueryException;
import org.eclipse.wst.xquery.marklogic.xcc.jndi.ContentSourceBean;

public class MarkLogicRunner
implements IInterpreterRunner {
    MarkLogicInstall install;

    public MarkLogicRunner(MarkLogicInstall install) {
        this.install = install;
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Executing on server.", 1);
        MarkLogicProcess process = new MarkLogicProcess(this.install, config, launch);
        launch.addProcess((IProcess)process);
        process.start();
        monitor.worked(1);
        monitor.done();
    }

    static class MarkLogicProcess
    extends Thread
    implements IProcess {
        protected ContentSourceBean contentSource = new ContentSourceBean();
        protected MockStreamsProxy streamsProxy = new MockStreamsProxy();
        protected MarkLogicInstall install;
        protected ILaunch launch;
        protected InterpreterConfig config;
        protected String xccUrl;
        protected String username;
        protected String password;

        public MarkLogicProcess(MarkLogicInstall install, InterpreterConfig config, ILaunch launch) {
            this.install = install;
            this.launch = launch;
            this.config = config;
            String[] parts = install.getInterpreterArgs().trim().split("\\|");
            this.xccUrl = parts[0];
            this.username = parts[1];
            this.password = parts[2];
        }

        public void run() {
            try {
                this.contentSource.setUrl(this.xccUrl);
            }
            catch (Throwable throwable) {
                this.streamsProxy.err("Unable to create content source.");
            }
            Session session = this.contentSource.newSession(this.username, this.password);
            try {
                try {
                    String chunk;
                    BufferedReader reader = new BufferedReader(new FileReader(this.config.getScriptFilePath().toFile()));
                    StringBuilder buffer = new StringBuilder();
                    while ((chunk = reader.readLine()) != null) {
                        buffer.append(chunk);
                        buffer.append("\n");
                    }
                    String source = buffer.toString();
                    AdhocQuery request = session.newAdhocQuery(source);
                    ResultSequence result = session.submitRequest((Request)request);
                    if (result.isEmpty()) {
                        this.streamsProxy.out("No results.\n");
                    } else {
                        this.streamsProxy.out(result.asString());
                    }
                }
                catch (XQueryException xqe) {
                    String message = xqe.toString();
                    message = message.substring(message.indexOf(58) + 2);
                    this.streamsProxy.err(message);
                    session.close();
                }
                catch (Throwable e) {
                    this.streamsProxy.err("Execution failed: ");
                    this.streamsProxy.err(e.toString());
                    e.printStackTrace();
                    session.close();
                }
            }
            finally {
                session.close();
            }
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getAttribute(String key) {
            return null;
        }

        public int getExitValue() throws DebugException {
            return 0;
        }

        public String getLabel() {
            return "Mark Logic Server " + this.xccUrl + " [user=" + this.username + "]";
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public IStreamsProxy getStreamsProxy() {
            return this.streamsProxy;
        }

        public void setAttribute(String key, String value) {
        }

        public boolean canTerminate() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public void terminate() throws DebugException {
        }
    }
}

