/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.marklogic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.wst.xquery.core.semantic.ISemanticValidator;
import org.eclipse.wst.xquery.core.semantic.SemanticCheckError;
import org.eclipse.wst.xquery.internal.launching.marklogic.MockStreamsProxy;
import org.eclipse.wst.xquery.marklogic.xcc.AdhocQuery;
import org.eclipse.wst.xquery.marklogic.xcc.Request;
import org.eclipse.wst.xquery.marklogic.xcc.ResultSequence;
import org.eclipse.wst.xquery.marklogic.xcc.Session;
import org.eclipse.wst.xquery.marklogic.xcc.exceptions.XQueryException;
import org.eclipse.wst.xquery.marklogic.xcc.jndi.ContentSourceBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkLogicSemanticValidator
implements ISemanticValidator {
    private IInterpreterInstall fInterpreterInstall;
    protected ContentSourceBean contentSource = new ContentSourceBean();
    protected String xccUrl;
    protected MockStreamsProxy streamsProxy = new MockStreamsProxy();

    public MarkLogicSemanticValidator(IInterpreterInstall install) {
        this.fInterpreterInstall = install;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    public List<SemanticCheckError> check(ISourceModule module) throws CoreException {
        String[] parts = this.fInterpreterInstall.getInterpreterArgs().trim().split("\\|");
        String url = parts[0];
        String username = parts[1];
        String password = parts[2];
        try {
            this.contentSource.setUrl(url);
        }
        catch (Throwable throwable) {
            this.streamsProxy.err("Unable to create content source.");
        }
        Session session = this.contentSource.newSession(username, password);
        try {
            try {
                AdhocQuery request = session.newAdhocQuery("xquery version \"1.0-ml\";\nxdmp:eval(\"" + module.getSource().replace("\"", "\"\"") + ",SEMANTIC:OK\")");
                ResultSequence result = null;
                try {
                    result = session.submitRequest((Request)request);
                    if (result.isEmpty()) {
                        this.streamsProxy.err("No request id returned from debugger.\n");
                    } else {
                        this.streamsProxy.out(result.asString());
                    }
                }
                catch (XQueryException e) {
                    if (!"XDMP-UNBPRFX".equals(e.getCode()) || !"SEMANTIC".equals(e.getData()[0])) {
                        throw e;
                    }
                }
            }
            catch (XQueryException e) {
                ArrayList<SemanticCheckError> errors = new ArrayList<SemanticCheckError>();
                errors.add(new SemanticCheckError(module.getPath().toPortableString(), e.getCode(), e.getFormatString(), e.getStack()[0].getLineNumber() - 1));
                ArrayList<SemanticCheckError> arrayList = errors;
                session.close();
                return arrayList;
            }
            catch (Throwable e) {
                this.streamsProxy.err("Execution failed: ");
                this.streamsProxy.err(e.toString());
                e.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
        return null;
    }
}

