/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.internal.launching.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.wst.xquery.launching.IXQDTBuiltinDocProvider;
import org.eclipse.wst.xquery.launching.ModuleSearchPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinModuleUtil {
    public static List<ModuleSearchPath> readBuiltinModuleSearchPaths(IInterpreterInstallType interpreterInstallType) {
        IConfigurationElement[] searchPaths;
        ArrayList<ModuleSearchPath> paths = new ArrayList<ModuleSearchPath>();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.launching", "builtinModules");
        IConfigurationElement[] iConfigurationElementArray = searchPaths = extPoint.getConfigurationElements();
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement searchPath = iConfigurationElementArray[n2];
            String installTypeId = searchPath.getAttribute("installType");
            if (installTypeId.equals(interpreterInstallType.getId())) {
                String path = searchPath.getAttribute("path");
                boolean relative = Boolean.parseBoolean(searchPath.getAttribute("relative"));
                paths.add(new ModuleSearchPath(path, relative));
            }
            ++n2;
        }
        return paths;
    }

    public static Map<String, String> readBuiltinDocs(IInterpreterInstallType interpreterInstallType) {
        IConfigurationElement[] searchPaths;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.xquery.launching", "builtinModules");
        IConfigurationElement[] iConfigurationElementArray = searchPaths = extPoint.getConfigurationElements();
        int n = searchPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement searchPath = iConfigurationElementArray[n2];
            String installTypeId = searchPath.getAttribute("installType");
            if (installTypeId.equals(interpreterInstallType.getId())) {
                try {
                    IXQDTBuiltinDocProvider docProvider = (IXQDTBuiltinDocProvider)searchPath.createExecutableExtension("docProvider");
                    return docProvider.getDocs();
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return new HashMap<String, String>();
    }
}

