/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xquery.launching;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.wst.xquery.core.semantic.ISemanticValidator;
import org.eclipse.wst.xquery.core.semantic.SemanticCheckError;
import org.eclipse.wst.xquery.core.semantic.SemanticCheckErrorReportReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalInterpreterSemanticValidator
implements ISemanticValidator {
    private IInterpreterInstall fInterpreterInstall;

    public AbstractLocalInterpreterSemanticValidator(IInterpreterInstall install) {
        this.fInterpreterInstall = install;
    }

    protected IInterpreterInstall getInterpreterInstall() {
        return this.fInterpreterInstall;
    }

    public List<SemanticCheckError> check(ISourceModule module) throws CoreException {
        SemanticCheckErrorReportReader builder;
        List errors;
        Thread t;
        StringBuffer[] buffer;
        block10: {
            IExecutionEnvironment exeEnv = this.fInterpreterInstall.getExecEnvironment();
            String[] cmdLine = this.buildCommandLine(module);
            EnvironmentVariable[] environmentVariables = this.fInterpreterInstall.getEnvironmentVariables();
            String[] vars = null;
            if (environmentVariables != null && environmentVariables.length > 0) {
                vars = new String[environmentVariables.length];
                int i = 0;
                while (i < environmentVariables.length) {
                    vars[i] = environmentVariables[i].toString();
                    ++i;
                }
            }
            final Process p = exeEnv.exec(cmdLine, null, vars);
            buffer = new StringBuffer[2];
            if (p == null) {
                this.abort("Could not invoke the Semantic Validator");
            }
            try {
                t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            String line;
                            String line2;
                            BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));
                            StringBuffer outputReport = new StringBuffer();
                            while ((line2 = output.readLine()) != null) {
                                outputReport.append(String.valueOf(line2) + "\n");
                            }
                            buffer[1] = outputReport;
                            BufferedReader errstr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                            StringBuffer errorReport = new StringBuffer();
                            while ((line = errstr.readLine()) != null) {
                                errorReport.append(String.valueOf(line) + "\n");
                            }
                            buffer[0] = errorReport;
                        }
                        catch (IOException iOException) {}
                    }
                });
                t.start();
                int errorCode = p.waitFor();
                if (errorCode != 0) break block10;
                return null;
            }
            catch (InterruptedException interruptedException) {
                this.abort("Exception while waiting for the Semantic Validator to terminate");
                return null;
            }
        }
        t.join();
        if (buffer[0] == null || buffer[0].toString().trim().length() == 0) {
            if (buffer[1] == null || buffer[1].toString().trim().length() == 0) {
                this.abort("An unknown error occured while executing the Semantic Validator command");
            } else {
                this.abort("An error occured while executing the Semantic Validator command:\n" + buffer[1].toString().trim());
            }
        }
        if ((errors = (builder = new SemanticCheckErrorReportReader(module, buffer[0].toString())).getErrors()) == null || errors.size() == 0) {
            this.abort("An error occured while executing the Semantic Validator command:\n" + buffer[0].toString().trim());
        }
        return errors;
    }

    public abstract String[] buildCommandLine(ISourceModule var1);

    private void abort(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xquery.core", message));
    }
}

